;(defun select (x num) 
;	(if (= num 0)
;		(car x)
;		(select (cdr x) (- num 1))
;	)
;)

'(defun select (x num)
	(let
		(
			(a num)
			(b x)
		)
		(while (> a 0)
			(def b (cdr b))
			(def a (- a 1))
		)
		(car b)
	)
)

(defun length (x)
	(let
		(
			(a 0)
		)
		(while x
			(def a (+ a 1))
			(def x (cdr x))
		)
		a
	)
)

;(defun MatSelect(a ni mi)
;	(if (= ni 0)
;		(select (car a) mi)
;		(MatSelect (cdr a) (- ni 1))
;	)
;)

(defun MatSelect(a ni mi)
	(let
		(
			(num ni)
			(x a)
		)
		(while (> num 0)
			(def x (cdr x))
			(def num (- num 1))
		)
		(select (car x) mi)
	)
)

(defun and (a b)
	(if a
		(if b
			t
			nil
		)
		nil
	)
)

(defun or (a b)
	(if a
		t
		(if b
			t
			nil
		)
	)
)

(defun not (a)
	(if a
		nil
		t
	)
)

(defun VAdd(a b)
	(if (and a b)
		(cons (+ (car a) (car b)) (VAdd (cdr a) (cdr b)))
		nil
	)
)

(defun VSub(a b)
	(if (and a b)
		(cons (- (car a) (car b)) (VSub (cdr a) (cdr b)))
		nil
	)
)

(defun VMul(a b)
	(if a
		(cons (* (car a) b) (VMul (cdr a) b))
		nil
	)
)

(defun VDiv(a b)
	(if a
		(cons (/ (car a) b) (VDiv (cdr a) b))
		nil
	)
)

(defun VDot(a b)
	(if (and a b)
		(+ (* (car a) (car b)) (VDot (cdr a) (cdr b)))
		0
	)
)

(defun VCross(a b)
	(let
		(
			(a0 (select a 0))
			(a1 (select a 1))
			(a2 (select a 2))
			(b0 (select b 0))
			(b1 (select b 1))
			(b2 (select b 2))
		)
		(list
			(- (* a1 b2) (* a2 b1))
			(- (* a2 b0) (* a0 b2))
			(- (* a0 b1) (* a1 b0))
		)
	)
)

(defun VSquareMagnitude (va)
	(let
		(
			(a va)
			(b 0.0)
		)
		(while a
			(def b (+ b (* (car a) (car a))))
			(def a (cdr a))
		)
		b
	)
)

(defun VMagnitude (va)
	(sqrt (VSquareMagnitude va))
)

(def _VDevide_Error 0.0000000001)

(defun VNormalize (va)
	(let
		(
			(sz (VMagnitude va))
		)
		(if (> sz _VDevide_Error)
			(VDiv va sz)
			nil
		)
	)
)

(defun _VMatMul (a b c)
	(if a
		(_VMatMul (cdr a) (cdr b) (VAdd (VMul (car b) (car a)) c))
		c
	)
)

(defun VMatMul (a b)
	(_VMatMul (cdr a) (cdr b) (VMul (car b) (car a)))
)

(defun MatMul (a b)
	(if a
		(cons (VMatMul (car a) b) (MatMul (cdr a) b))
		nil
	)
)


(defun assoc_list_add (lst name obj)
	(cons (list name obj) lst)
)

(defun assoc_list_search_check (a name)
	(if a
		(not (eq name (car (car a))))
		nil
	)
)


(defun assoc_list_search (lst name)
	(let
		(
			(a lst)
		)
		
		(while (assoc_list_search_check a name)
			(def a (cdr a))
		)
		(if a
			(car (cdr (car a)))
			nil
		)
	)
)

;(defun assoc (name lst)
;
;)

(defun assoc_list_set (lst name obj)
	(let
		(
			(a lst)
			(pst nil)
			(top nil)
			(flg t)
		)
		
		(while (assoc_list_search_check a name)
			(def pst (cons (car a) pst))
			(def a (cdr a))
		)
		(if a
			((lambda ()
				(def top (list name obj))
				(def a (cdr a))
				(while pst
					(def a (cons (car pst) a))
					(def pst (cdr pst))
				)
				(cons top a)
			))
			(assoc_list_add lst name obj)
		)
	)
)

(defun assoc_list_rise (lst name)
	(let
		(
			(a lst)
			(pst nil)
			(top nil)
			(flg t)
		)
		
		(while (assoc_list_search_check a name)
			(def pst (cons (car a) pst))
			(def a (cdr a))
		)
		(if a
			((lambda ()
				(def top (car a))
				(def a (cdr a))
				(while pst
					(def a (cons (car pst) a))
					(def pst (cdr pst))
				)
				(cons top a)
			))
			lst
		)
	)
)


(defun reverse (x)
	(let
		(
			(a nil)
		)
		(while x
			(def a (cons (car x) a))
			(def x (cdr x))
		)
		a
	)
)


(defun append (a b)
	(reverse
		(let
			(
				(c nil)
			)
			(while a
				(def c (cons (car a) c))
				(def a (cdr a))
			)
			(while b
				(def c (cons (car b) c))
				(def b (cdr b))
			)
			c
		)
	)
)

(defun makenumlist (num)
	(let
		(
			(a nil)
			(i num)
		)
		(def i (- i 1))
		(while (>= i 0)
			(def a (cons i a))
			(def i (- i 1))
		)
		a
	)
)

(defun MakeNilMap (x y)
	(let
		(
			(i y)
			(j x)
			(lst nil)
			(nlst nil)
		)
		(while (> i 0)
			(def j x)
			(def nlst nil)
			(while (> j 0)
				(def nlst (cons nil nlst))
				(def j (- j 1))
			)
			(def lst (cons nlst lst))
			(def i (- i 1))
		)
		lst
	)
)

(defun _SetMapList (x lst v)
	(if (<= x 0)
		(cons v (cdr lst))
		(cons (car lst) (_SetMapList (- x 1) (cdr lst)))
	)
)


(defun SetMapList (x y lst v)
	(if (<= y 0)
		(cons (_SetMapList x (car lst) v) (cdr lst))
		(cons (car lst) (SetMapList x (- y 1) (cdr lst) v))
	)
)
