(Load "defaultlisplib.lsp")
(Load "keys.lsp")

(defun PhSetUpForFixedObject (x)
	(SetXPhBodyPhysicsMode x 0)
	(XPhBodySetSameCGroupEachChild x)
)

(defun PhSetUpDefaultJointParam (jnt parent child)
	(XPhBodyJointAxisSpringLimit jnt 0.025)
	(XPhBodyJointTorqueSpringLimit jnt 0.05)
	(XPhBodyJointSpringCoeff jnt (/ 240.0 (GetCollisionSatisfyCoefficientScale)))
	(XPhBodyJointSpringDamper jnt (/ 0.025 (GetCollisionSatisfyCoefficientScale)))
	(XPhJointSetRotationalDamper jnt 1.0)
	(XPhBodyJointGuessParam jnt)
)

(defun PhMakeJointWithGuessParam (parent child pos axis dir)
	;parent: e̕, child: q̕,
	;pos: ֐߂̈ʒu(e̍Wn),
	;axis: ֐߂̎(e̍Wn), dir: ֐߂̕(e̍Wn)
	(let
		(
			(jnt (XPhBodyAddJointChild parent child
					 pos axis dir 1.0))
		)
		(PhSetUpDefaultJointParam jnt parent child)
		(XPhBodyJointGuessParam jnt)

		jnt
	)

)

(defun PhGetRotateMat (ma)
	(let
		(
			(i 0)
			(a nil)
			(b ma)
		)
	
		(while (< i 3)
			(def a (cons (car b) a))
			(def b (cdr b))

			(def i (+ 1 i))
		)
		(def a (reverse a))
		a
	)
	
)


(defun PhMatMul (a b)
	(let
		(
			(ra (PhGetRotateMat a))
			(rb (PhGetRotateMat b))
			(la (select a 3))
			(lb (select b 3))
		)

		(let
			(
				(a (MatMul ra rb))
				(b (VAdd (VMatMul la rb) lb))
			)

			(append 
				a (list b)
			)
		)
	)
)

(defun AppendMatVec (ma va)
	(append
		ma (list va)
	)
)

(defun ScaleMat (s)
	(list 
		(list s 0 0)
		(list 0 s 0)
		(list 0 0 s)
	)
)

(defun XRotMat (theta)
	(let
		(
			(c (cos theta))
			(s (sin theta))
		)
		(list
			(list 1 0 0)
			(list 0 c s)
			(list 0 (- 0 s) c)
		)
	)
)

(defun YRotMat (theta)
	(let
		(
			(c (cos theta))
			(s (sin theta))
		)
		(list
			(list c 0 (- 0 s))
			(list 0 1 0)
			(list s 0 c)
		)
	)
)

(defun ZRotMat (theta)
	(let
		(
			(c (cos theta))
			(s (sin theta))
		)
		(list
			(list c s 0)
			(list (- 0 s) c 0)
			(list 0 0 1)
		)
	)
)

(defun LookAtMat (t p up)
	(let
		(
			(d (VNormalize (VSub t p)))
			(r (VNormalize (VCross d up)))
			(up2 (VNormalize (VCross r d)))
		)
		(list (VMul r -1) up2 d p)
	)
)

(defun Translate (v Mat)
	(VAdd
		(VAdd
			(VMul (select Mat 0) (select v 0))
			(VMul (select Mat 1) (select v 1))
		)
		(VAdd
			(VMul (select Mat 2) (select v 2))
			(select Mat 3)
		)
	)
)

(defun InvTranslate (v Mat)
	(let
		(
			(va (VSub v (select Mat 3)))
		)
		(list
			(VDot (select Mat 0) va)
			(VDot (select Mat 1) va)
			(VDot (select Mat 2) va)
		)
	)
)

(defun ScaleAndResetBoxInertiaTensor (obj scale)
	(SetXPhVertexTransformMat obj 
		(AppendMatVec 
			(ScaleMat scale)
			'(0 0 0)
		)
	)
	(XPhBodySetInertiaTensor obj (XPhBodyGetInertiaTensorFromAABB obj))
)

(defun PhDrawAxis (this)		;rI悭ĝŊ֐ɂĂ܂
	(def x_axis (select (GetXPhBodyMat this) 0))	;x̎擾
	(def y_axis (select (GetXPhBodyMat this) 1))	;y̎擾
	(def z_axis (select (GetXPhBodyMat this) 2))	;z̎擾
	(def pos (select (GetXPhBodyMat this) 3))	;dS̈ʒu̎擾
	

	(XPhDrawLine 	;`悷֐
		'(255 0 0 255) 	;F'(sx   )ꂼ0`255
		pos		;̎n_
		(VAdd pos x_axis)	;̏I_
					;VAdd̓xNgm̑Z
	)	;x̕`

	(XPhDrawLine '(255 0 0 255) pos (VAdd pos y_axis))
				;y̕`
	(XPhDrawLine '(255 0 0 255) pos (VAdd pos z_axis))
				;z̕`
)

(defun PhDrawAABB (aabb)
	(let
		(
			(p0 (car aabb))
			(p1 (car (cdr aabb)))
			(p0x (select p0 0))
			(p0y (select p0 1))
			(p0z (select p0 2))
			(p1x (select p1 0))
			(p1y (select p1 1))
			(p1z (select p1 2))
		)
		
		(XPhDrawLine '(255 0 0 255)
			(list  p0x p0y p0z)
			(list  p0x p0y p1z)
		)
		(XPhDrawLine '(255 0 0 255)
			(list  p0x p0y p0z)
			(list  p0x p1y p0z)
		)
		(XPhDrawLine '(255 0 0 255)
			(list  p0x p0y p0z)
			(list  p1x p0y p0z)
		)

		(XPhDrawLine '(255 0 0 255)
			(list  p1x p0y p1z)
			(list  p0x p0y p1z)
		)
		(XPhDrawLine '(255 0 0 255)
			(list  p0x p1y p1z)
			(list  p0x p1y p0z)
		)
		(XPhDrawLine '(255 0 0 255)
			(list  p1x p1y p0z)
			(list  p1x p0y p0z)
		)

		(XPhDrawLine '(255 0 0 255)
			(list  p1x p0y p1z)
			(list  p1x p1y p1z)
		)
		(XPhDrawLine '(255 0 0 255)
			(list  p0x p1y p1z)
			(list  p1x p1y p1z)
		)
		(XPhDrawLine '(255 0 0 255)
			(list  p1x p1y p0z)
			(list  p1x p1y p1z)
		)

		(XPhDrawLine '(255 0 0 255)
			(list  p0x p1y p1z)
			(list  p0x p0y p1z)
		)
		(XPhDrawLine '(255 0 0 255)
			(list  p1x p1y p0z)
			(list  p0x p1y p0z)
		)
		(XPhDrawLine '(255 0 0 255)
			(list  p1x p0y p1z)
			(list  p1x p0y p0z)
		)


	)
)

(defun PhDrawPoint (p)		;rI悭ĝŊ֐ɂĂ܂

	(XPhDrawLine
		'(0 255 0 255)
		(VSub p '(0.5 0 0)) (VAdd p '(0.5 0 0))
	)

	(XPhDrawLine
		'(0 255 0 255)
		(VSub p '(0 0.5 0)) (VAdd p '(0 0.5 0))
	)

	(XPhDrawLine
		'(0 255 0 255)
		(VSub p '(0 0 0.5)) (VAdd p '(0 0 0.5))
	)
)


(defun PhDefaultParamSetUp ()
	;Î~CW̐ݒ
	(SetCollisionStaticFrictionCoeff 0.2)

	;CW̐ݒ
	(SetCollisionDynamicFrictionCoeff 0.1)

	;߂荞݋eʂ̐ݒ
	(SetInterferencePermitDistance 0.1)

	;ڐĜ΂˂̗͂̐ݒ
	(SetCollisionSpringCoeff 20.0)
	(GetCollisionSpringCoeff)

	(SetCollisionSatisfyCoefficientScale 10.0f)
	(GetCollisionSatisfyCoefficientScale)

	(SetCollisionVerticalDamperCoeff 0.025)
	'(SetCollisionReboundCoeff 0.0)

	;(SetRetryCollisionMax 128)
	(SetCollisionSatisfyRepeatMax 256)
	(SetRetryCollisionMax 6)
	(SetLinkSatisfyRepeatMax 4)
)

;(PhDefaultParamSetUp)
