(Load "ph3dlib.lsp")

(def PhBodyClass
	'(
		(SuperClass nil)

		(Init
			'(lambda ()
				(def CurrentState States)
			)
		)

		(DebugMode t)
		(DebugStrings '(" "))
		(AddDebugString 
			'(lambda (str)
				(def DebugStrings (cons str DebugStrings))
			)
		)
		
		(Step 
			'(lambda ()
				(let
					(
						(dt (GetSimulationStepSize))
					)
					(if (and DebugMode CurrentState)
						(progn
							(AddDebugString 
								(PrintString (car CurrentState))
							)
							(AddDebugString "\n")
						)
						(progn
							(AddDebugString 
								(PrintString CurrentState)
							)
							(AddDebugString "\n")
						)
					)
					(while
						(eval (eval (car (cdr (car CurrentState)))))
						nil
					)
					(def TimeCounter (+ TimeCounter dt))

					(if DebugMode
						(progn
							(def DebugStrings (reverse DebugStrings))
							(XPhSet_EasyViewText 
								(eval (cons strcat
									DebugStrings
								))
							)
							(def DebugStrings '(" "))
						)
						nil
					)
				)

			)
		)

		;ԑJڗp
		(States 
			(
				(Start '(TimerNext 1.0 DoNone))
				(nil '(TimerNext 1.0 '(lambda () (Walk 1.0))))
				(nil '(TimerNext 1.0 '(lambda () (Roll 1.0))))
				(nil '(GoLabel 'Start))
			)
		)
		(CurrentState nil)
		(SetNextState 
			'(lambda (nxt)
				(def CurrentState nxt)
			)
		)

		(DoNone '(lambda () nil))

		(TimeCounter 0.0)
		(TimerNext
			'(lambda (tim event)
				(if (> (+ TimeCounter 0.0000001) tim)
					(progn
						(def TimeCounter (- TimeCounter tim))
						(def CurrentState (cdr CurrentState))
						t
					)
					(progn
						(event)
						nil
					)
				)
			)
		)
		(GoLabel
			'(lambda (label)
				(def CurrentState States)
				(while (assoc_list_search_check CurrentState label)
					'(SaveAtom CurrentState)
					(def CurrentState (cdr CurrentState))
				)
				t
			)
		)

		(Walk '(lambda (v) (if DebugMode (AddDebugString "Walk")) nil))
		(Roll '(lambda (v) (if DebugMode (AddDebugString "Roll")) nil))

	)
)

'(with PhBodyClass DoNone)



(defun PhBody_SetFunction (this data)
	(XPhBodySetData this data)
	(XPhBodySetFunction this
		'(lambda (this)
			(let
				(
					(data (XPhBodyGetData this))
				)
				(with data
					(Step)
				)
				(XPhBodySetData this data)
			)
		)
	)
)

(defun PhBody_Create (PhBodyClass)
	(with PhBodyClass (Init))
	PhBodyClass
)

'(PhBody_Inherit_Permutation '((lambda () (+ 1 2))) 'inherited
	'(('cons 'a 'b) ('list '('inherited 'test 'aa ('inherited))))
)

(defun PhBody_Inherit_Permutation (a key lst)
	(let
		(
			(nlst nil)
		)
		(if (not (atom lst))
			(progn
				(while lst
					;(print lst)
					(if (not (atom lst))
						(if (eq key (car lst))
							(def nlst (cons (cdr lst) (cons a nlst)))
							(def nlst 
								(cons (PhBody_Inherit_Permutation a key (car lst))
									nlst)
							)
						)
						(def nlst (cons lst nlst))
					)
					(def lst (cdr lst))
				)
				(reverse nlst)
			)
			lst
		)
	)
)

(defun PhBody_Inherit (PhBodyClass lst)
	(let
		(
			(res nil)
			(cur nil)
			(tmpclass PhBodyClass)
		)

		;(with tmpclass
			(while lst

				(def PhBodyClass
					(assoc_list_set PhBodyClass
						(car (car lst))
						(car (cdr (car lst)))
					)
				)

				(print (assoc_list_search tmpclass (car (car lst))))
	
				(def cur (car PhBodyClass))
				(def PhBodyClass (cdr PhBodyClass))
				(def cur
					(PhBody_Inherit_Permutation (eval (assoc_list_search tmpclass (car (car lst)))) 'inherited cur)
				)
				(def res (cons cur res))
	
				(def lst (cdr lst))
			)
		;)
		(def res (append res PhBodyClass))
		res
	)
)


'(def lst
	'(
		(lambda () (+ 2 1))
		(lambda () (+ 23 32))
	)
)

(def PhMouseClass
	'(
		(SuperClass nil)

		(Init
			'(lambda ()
				nil
			)
		)

		(MouseDownFunc
			'(lambda ()
				nil
			)
		)

		(MouseMoveFunc
			'(lambda ()
				nil
			)
		)

		(MouseUpFunc
			'(lambda ()
				nil
			)
		)
	)
)
