(Load "ph3dlib.lsp")

(def PhObjClass
	'(
		(SuperClass nil)

		(Init
			'(lambda ()
				(def CurrentState States)
			)
		)

		(DebugMode t)
		(DebugStrings '(" "))
		(AddDebugString 
			'(lambda (str)
				(def DebugStrings (cons str DebugStrings))
			)
		)
		
		(Step 
			'(lambda ()
				(let
					(
						(dt (GetSimulationStepSize))
					)
					(if (and DebugMode CurrentState)
						(progn
							(AddDebugString 
								(PrintString (car CurrentState))
							)
							(AddDebugString "\n")
						)
						(progn
							(AddDebugString 
								(PrintString CurrentState)
							)
							(AddDebugString "\n")
						)
					)
					(while
						(eval (eval (car (cdr (car CurrentState)))))
						nil
					)
					(def TimeCounter (+ TimeCounter dt))

					(if DebugMode
						(progn
							(def DebugStrings (reverse DebugStrings))
							(XPhSet_EasyViewText 
								(eval (cons strcat
									DebugStrings
								))
							)
							(def DebugStrings '(" "))
						)
						nil
					)
				)

			)
		)

		;ԑJڗp
		(States 
			(
				(Start '(TimerNext 1.0 DoNone))
				(nil '(TimerNext 1.0 '(lambda () (Walk 1.0))))
				(nil '(TimerNext 1.0 '(lambda () (Roll 1.0))))
				(nil '(GoLabel 'Start))
			)
		)
		(CurrentState nil)
		(SetNextState 
			'(lambda (nxt)
				(def CurrentState nxt)
			)
		)

		(DoNone '(lambda () nil))

		(TimeCounter 0.0)
		(TimerNext
			'(lambda (tim event)
				(if (> (+ TimeCounter 0.0000001) tim)
					(progn
						(def TimeCounter (- TimeCounter tim))
						(def CurrentState (cdr CurrentState))
						t
					)
					(progn
						(event)
						nil
					)
				)
			)
		)
		(GoLabel
			'(lambda (label)
				(def CurrentState States)
				(while (assoc_list_search_check CurrentState label)
					'(SaveAtom CurrentState)
					(def CurrentState (cdr CurrentState))
				)
				t
			)
		)

		(Walk '(lambda (v) (if DebugMode (AddDebugString "Walk")) nil))
		(Roll '(lambda (v) (if DebugMode (AddDebugString "Roll")) nil))

	)
)

'(with PhObjClass DoNone)



(defun PhObj_SetFunction (this data)
	(XPhObjSetData this data)
	(XPhObjSetFunction this
		'(lambda (this)
			(let
				(
					(data (XPhObjGetData this))
				)
				(with data
					(Step)
				)
				(XPhObjSetData this data)
			)
		)
	)
)

(defun PhObj_Create (PhObjClass)
	(with PhObjClass (Init))
	PhObjClass
)

'(PhObj_Inherit_Permutation '((lambda () (+ 1 2))) 'inherited
	'(('cons 'a 'b) ('list '('inherited 'test 'aa ('inherited))))
)

(defun PhObj_Inherit_Permutation (a key lst)
	(let
		(
			(nlst nil)
		)
		(if (not (atom lst))
			(progn
				(while lst
					;(print lst)
					(if (not (atom lst))
						(if (eq key (car lst))
							(def nlst (cons (cdr lst) (cons a nlst)))
							(def nlst 
								(cons (PhObj_Inherit_Permutation a key (car lst))
									nlst)
							)
						)
						(def nlst (cons lst nlst))
					)
					(def lst (cdr lst))
				)
				(reverse nlst)
			)
			lst
		)
	)
)

(defun PhObj_Inherit (PhObjClass lst)
	(let
		(
			(res nil)
			(cur nil)
			(tmpclass PhObjClass)
		)

		;(with tmpclass
			(while lst

				(def PhObjClass
					(assoc_list_set PhObjClass
						(car (car lst))
						(car (cdr (car lst)))
					)
				)

				(print (assoc_list_search tmpclass (car (car lst))))
	
				(def cur (car PhObjClass))
				(def PhObjClass (cdr PhObjClass))
				(def cur
					(PhObj_Inherit_Permutation (eval (assoc_list_search tmpclass (car (car lst)))) 'inherited cur)
				)
				(def res (cons cur res))
	
				(def lst (cdr lst))
			)
		;)
		(def res (append res PhObjClass))
		res
	)
)


'(def lst
	'(
		(lambda () (+ 2 1))
		(lambda () (+ 23 32))
	)
)

(def PhMouseClass
	'(
		(SuperClass nil)

		(Init
			'(lambda ()
				nil
			)
		)

		(MouseDownFunc
			'(lambda ()
				nil
			)
		)

		(MouseMoveFunc
			'(lambda ()
				nil
			)
		)

		(MouseUpFunc
			'(lambda ()
				nil
			)
		)
	)
)
