;Cu̓ǂݍ
(Load "defaultlisplib.lsp")
(Load "ph3dlib.lsp")

(defun MakeTire (body dir up st offset)
	(let*
		(
			(data (XPhBodyGetData body))
			(jointlist (assoc_list_search data 'joints))
			(tire (LoadXPhBody "tireld.x"))
			(scale 0.25)

			(mat (GetXPhBodyMat body))
			(cp (VCross dir up))
			(ma nil)
			(sta (VAdd st (select mat 3)))
		)

		(LoadXPhBodyVisual tire "tire.x")
		(XPhBodySetMass tire 1.0)
		(XPhBodySetVisualMaterial tire '((1 1 1 1) (0.5 0.5 0.5 0.5) (0 0 0 0) 0))
		(ScaleAndResetBoxInertiaTensor tire scale)
		
		(SetXPhVertexTransformMat tire 
			(AppendMatVec 
				(YRotMat (* -0.5 (PI)))
				'(0 0 0)
			)
		)

		(def ma (LookAtMat (VAdd sta cp) sta up))

		(SetXPhBodyMat tire ma)

		(let*
			(
				(jnt (XPhBodyAddJointChild body tire
					 (VAdd st offset)
						dir up (* 1.25 scale)))
			)

			(PhSetUpDefaultJointParam jnt body tire)
			(XPhJointSetRotationalDamper jnt 0.2)
			'(XPhBodyJointSpringCoeff jnt 1000.0)
			'(XPhBodyJointSpringDamper jnt 4.5)

			(XPhBodyJointLimitFlag jnt nil)


			(def data (assoc_list_set data 'joints 
				(cons jnt jointlist))
			)

			(XPhBodySetData body data)
		)

		tire
	)
)


(defun MakeAutoMobile ()
	(let*
		(
			(AutoMobile (LoadXPhBody "kbody_ld.x"))
		)

		(LoadXPhBodyVisual AutoMobile "kbody.x")
		(SetXPhBodyMat AutoMobile '((1 0 0) (0 1 0) (0 0 1) (0 5 0)))
		(SetXPhVertexTransformMat AutoMobile 
			(AppendMatVec 
				(MatMul
					(XRotMat (* -0.5 (PI)))
					(YRotMat (PI))
				)
				'(0 0.25 -1)
			)
		)

		(XPhBodySetMass AutoMobile 4.0)
		(ScaleAndResetBoxInertiaTensor AutoMobile 1.0)

		(XPhBodySetData AutoMobile nil)

		(MakeTire AutoMobile '(1 0 0) '(0 1 0)
				'(1.25 -0.65 1.35) '(-0.25 0 0))
		(MakeTire AutoMobile '(1 0 0) '(0 1 0)
				'(1.25 -0.65 -1.35) '(-0.25 0 0))
		(MakeTire AutoMobile '(1 0 0) '(0 1 0)
				'(-1.25 -0.65 1.35) '(0.25 0 0))
		(MakeTire AutoMobile '(1 0 0) '(0 1 0)
				'(-1.25 -0.65 -1.35) '(0.25 0 0))

		AutoMobile
	)
)
