;Cu̓ǂݍ
(Load "defaultlisplib.lsp")
(Load "ph3dlib.lsp")


(defun MakeLeg (body ma rvec)
	(let*
		(
			(data (XPhBodyGetData body))
			(jointlist (assoc_list_search data 'joints))
			(l0 (LoadXPhBody "leg.x"))
			(l1 (LoadXPhBody "leg3.x"))
			(l2 (LoadXPhBody "leg2.x"))
			(scale 0.5)
		)
		
		(LoadXPhBodyVisual l0 "dleg.x")
		(LoadXPhBodyVisual l1 "dleg3.x")
		(LoadXPhBodyVisual l2 "dleg2.x")

		(ScaleAndResetBoxInertiaTensor l0 scale)
		(ScaleAndResetBoxInertiaTensor l1 scale)
		(ScaleAndResetBoxInertiaTensor l2 scale)

		(SetXPhBodyMat l0 (list 
					(select ma 0)
					(select ma 1)
					(select ma 2)
					(VAdd (select ma 3) (VMul (select ma 1) (* -1.0 scale)))
				)
			)

		(SetXPhBodyMat l1 (list 
					(select ma 0)
					(select ma 1)
					(select ma 2)
					(VAdd (select ma 3) (VMul (select ma 1) (* -3.0 scale)))
				)
			)

		(SetXPhBodyMat l2 (list 
					(select ma 0)
					(select ma 1)
					(select ma 2)
					(VAdd (select ma 3) (VMul (select ma 1) (* -5.25 scale)))
				)
			)

		(let*
			(
				(jnt (XPhBodyAddJointChild body l0
					; (list 0 (* -1 scale) 0)
					rvec
					'(0 1 0) (select ma 2) (* 1.0 scale)))

				(jnt1 (XPhBodyAddJointChild l1 l2
					 (list 0 (* -1.25 scale) 0)
						'(1 0 0) '(0 0 -1) (* 1.0 scale)))
				(jnt0 (XPhBodyAddJointChild l0 l1
					 (list 0 (* -1 scale) 0) '(1 0 0) '(0 0 -1) (* 1.0 scale)))
				

			)

			(PhSetUpDefaultJointParam jnt0 l0 l1)
			(PhSetUpDefaultJointParam jnt1 l1 l2)
			(PhSetUpDefaultJointParam jnt body l0)

			(XPhJointSetMaxTheta jnt (* 0.1 (PI)))
			(XPhJointSetMinTheta jnt (* -0.1 (PI)))

			(def data (assoc_list_set data 'joints 
				(cons (list jnt jnt0 jnt1) jointlist))
			)
			(XPhBodySetData body data)

			l0
		)
	)
)

(defun MakeLegWithState(crab x y st)
	(let*
		(
			(tcr nil)
			(tcv nil)
		)

		(def tcr
			(MatMul
				(XRotMat (* x (PI)))
				(MatMul 
					(YRotMat (* y (PI)))
					cr
				)
			)
		)
		(def tcv (VAdd cv st))
		(MakeLeg crab (AppendMatVec tcr tcv) st)
	)
)

(defun MakeCrab ()
	(let*
		(
			(crab (LoadXPhBody "kbody_ld.x"))
		)

		(LoadXPhBodyVisual crab "kbody.x")
		(SetXPhBodyMat crab '((1 0 0) (0 1 0) (0 0 1) (0 5 0)))
		(SetXPhVertexTransformMat crab 
			(AppendMatVec 
				(XRotMat (* -0.5 (PI))) 
				'(0 0 1)
			)
		)

		(XPhBodySetMass crab 4.0)
		(ScaleAndResetBoxInertiaTensor crab 0.75)

		(XPhBodySetData crab nil)

		;(XPhBodySetInertiaTensor crab
		;	(XPhBodyGetInertiaTensorFromAABB crab))

		;(SetXPhBodyMat crab (AppendMatVec (XRotMat (* 0.5 (PI))) '(0 0 0)))

		(let*
			(
				(cMat (GetXPhBodyMat crab))
				(cr (PhGetRotateMat cMat))
				(cv (select cMat 3))
				(tcr nil)
				(tcv nil)
			)
			
			(MakeLegWithState crab -0.04 0.25 '(0.45 -0.45 0.45))
			(MakeLegWithState crab -0.04 0.75 '(0.45 -0.45 -0.45))
			(MakeLegWithState crab -0.04 -0.25 '(-0.45 -0.45 0.45))
			(MakeLegWithState crab -0.04 -0.75 '(-0.45 -0.45 -0.45))
		)

		;(MakeLeg crab (GetXPhBodyMat crab))

		crab
	)
)

;(defun CrabRemoveAllChild (crab)
;	
;)


