;Cu̓ǂݍ
(Load "defaultlisplib.lsp")
(Load "ph3dlib.lsp")

(XPhSet_EasyViewText 
	(strcat
		"LispSource/\nLispCrabCrane.lsp\n"
		"J[\L[ŕs\n"
		"E,Xŏ㏸~\n"
		"SłށCDŗ\n"
		"Z,CōEɐ\n"
		"Bň胂[h\n"
		"Vň胂[h\n"
		"I,M,J,KőO㍶EɈړ\n"
		"AŃWv\n"
	)
)

(XPhFogEnable t)
(XPhBgColor 200 200 203)

;΂ˌWȂǂ̃p[^̏
(PhDefaultParamSetUp)
'(SetCollisionSpringCoeff 20.0)
(SetCollisionSpringCoeff 15.0)

;Î~CW̐ݒ
(SetCollisionStaticFrictionCoeff 0.8)

;CW̐ݒ
(SetCollisionDynamicFrictionCoeff 0.7)

;̌`t@C̓ǂݍ
(def x (LoadXPhBody "road.x"))
;(def x (LoadXPhBody "pala.x"))
(PhSetUpForFixedObject x)
(SetXPhBodyMat x '((1 0 0) (0 1 0) (0 0 1) (0 -5 0)))
(SetXPhVertexTransformMat x '((5 0 0) (0 5 0) (0 0 5) (0 0 0)))
(XPhBodySetVisualMaterial x '((1 1 1 1) (0.5 0.5 0.5 0.5) (0 0 0 0) 0))

;I^{bgǂݍ
(Load "LispCrab.lsp")

(def tmp nil)

(defun CrabFunction (this)
	(let*
		(
			(data (XPhBodyGetData this))
			(jointlist (assoc_list_search data 'joints))
			(PIDList (assoc_list_search data 'PIDs))
			(view (assoc_list_search data 'view_point))
			(vtarget (assoc_list_search data 'view_target))
			(vup (assoc_list_search data 'view_up))
			(ta (assoc_list_search data 'ta))
			(balancemode (assoc_list_search data 'balancemode))
			(graspflg (assoc_list_search data 'graspflg))
			(dt (GetSimulationStepSize))
			(tMat (GetXPhBodyMat this))
			(mvflag 1.0)
			(mvflag2 0.0)
			(noinput t)
		)

		(XPhJointSetMinTheta (select (select jointlist 0) 2) 0)
		(XPhJointSetMinTheta (select (select jointlist 1) 2) 0)
		(XPhJointSetMinTheta (select (select jointlist 2) 2) 0)
		(XPhJointSetMinTheta (select (select jointlist 3) 2) 0)

		(XPhJointSetMaxTheta (select (select jointlist 0) 1) 0)
		(XPhJointSetMaxTheta (select (select jointlist 1) 1) 0)
		(XPhJointSetMaxTheta (select (select jointlist 2) 1) 0)
		(XPhJointSetMaxTheta (select (select jointlist 3) 1) 0)

		(if (XPhBodyGetKeyState this 40)	;L[ꂽꍇ
			(def mvflag -1.0)
			nil
		)
		(if (XPhBodyGetKeyState this 38)	;L[ꂽꍇ
			(def mvflag 1.0)
			nil
		)

		(if (XPhBodyGetKeyState this 37)	;L[ꂽꍇ
			(def mvflag2 -1.0)
			nil
		)

		(if (XPhBodyGetKeyState this 39)	;L[ꂽꍇ
			(def mvflag2 1.0)
			nil
		)


		(if 
			(or
				(or
					(XPhBodyGetKeyState this 38)	;L[ꂽꍇ
					(XPhBodyGetKeyState this 40)	;L[ꂽꍇ
				)
				(or
					(XPhBodyGetKeyState this 37)	;L[ꂽꍇ
					(XPhBodyGetKeyState this 39)	;L[ꂽꍇ
				)
			)
			(let*
				(
					(fa 100)
					(fa2 200)
					(fa3 50)
					(sa 
						'(lambda (ta) ()
							(if (< (sin ta) 0)
								(+ 1.0 (* (sin ta) 1.0))
								1.0
							)
						)
					)
					(t0 (* (sa ta) (* 0.5 (PI))))
					(t1 (* (sa (+ ta (PI))) (* 0.5 (PI))) )
					;(t0 (sin ta))
					;(t1 (sin (+ ta (PI))))
					(s0 (* (* (sin ta) (* 0.15 (PI)) ) mvflag) )
					(s1 (* (*  (sin (+ ta (PI))) (* 0.15 (PI)) ) mvflag) )
					(is0 (* (* (- 0 (sin ta)) (* 0.15 (PI)) ) mvflag))
				)

				(XPhJointSetBrake (select (select jointlist 0) 0) 0)
				(XPhJointSetBrake (select (select jointlist 1) 0) 0)
				(XPhJointSetBrake (select (select jointlist 2) 0) 0)
				(XPhJointSetBrake (select (select jointlist 3) 0) 0)

				(XPhJointSetStaticFrictionCoeff (select (select jointlist 0) 0) 0)
				(XPhJointSetStaticFrictionCoeff (select (select jointlist 1) 0) 0)
				(XPhJointSetStaticFrictionCoeff (select (select jointlist 2) 0) 0)
				(XPhJointSetStaticFrictionCoeff (select (select jointlist 3) 0) 0)

				(XPhJointSetDynamicFrictionCoeff (select (select jointlist 0) 0) 0)
				(XPhJointSetDynamicFrictionCoeff (select (select jointlist 1) 0) 0)
				(XPhJointSetDynamicFrictionCoeff (select (select jointlist 2) 0) 0)
				(XPhJointSetDynamicFrictionCoeff (select (select jointlist 3) 0) 0)

				(XPhJointSetTorque (select (select jointlist 0) 1) (- 0 fa3))
				(XPhJointSetTorque (select (select jointlist 1) 1) (- 0 fa3))
				(XPhJointSetTorque (select (select jointlist 2) 1) (- 0 fa3))
				(XPhJointSetTorque (select (select jointlist 3) 1) (- 0 fa3))

				(JointPIDControl jointlist PIDList 0 2 fa t0 dt)
				(JointPIDControl jointlist PIDList 2 2 fa t1 dt)

				(if (< (fabs mvflag2) 0.5)
					((lambda ()
						(JointPIDControl jointlist PIDList 1 2 fa t1 dt)
						(JointPIDControl jointlist PIDList 3 2 fa t0 dt)
					))
					((lambda ()
						(JointPIDControl jointlist PIDList 1 2 fa (* 0.5 (PI)) dt)
						(JointPIDControl jointlist PIDList 3 2 fa (* 0.5 (PI)) dt)
					))
				)

				;(JointPIDControl jointlist PIDList 0 0 fa2 s0 dt)
				;(JointPIDControl jointlist PIDList 1 0 fa2 s1 dt)
				;(JointPIDControl jointlist PIDList 2 0 fa2 s0 dt)
				;(JointPIDControl jointlist PIDList 3 0 fa2 s1 dt)

				(def noinput nil)

				(cond
					((> mvflag2 0.5)
						((lambda ()
							(JointPIDControl jointlist PIDList 0 0 fa2 (/ s1 2) dt)
							(JointPIDControl jointlist PIDList 1 0 fa2 (/ s0 2) dt)
							(JointPIDControl jointlist PIDList 2 0 fa2 (/ s0 2) dt)
							(JointPIDControl jointlist PIDList 3 0 fa2 (/ s1 2) dt)
						))
					)
					((< mvflag2 -0.5)
						((lambda ()
							(JointPIDControl jointlist PIDList 0 0 fa2 (/ s0 2) dt)
							(JointPIDControl jointlist PIDList 1 0 fa2 (/ s1 2) dt)
							(JointPIDControl jointlist PIDList 2 0 fa2 (/ s1 2) dt)
							(JointPIDControl jointlist PIDList 3 0 fa2 (/ s0 2) dt)
						))
					)
					(t
						((lambda ()
							(JointPIDControl jointlist PIDList 0 0 fa2 s0 dt)
							(JointPIDControl jointlist PIDList 1 0 fa2 s1 dt)
							(JointPIDControl jointlist PIDList 2 0 fa2 s0 dt)
							(JointPIDControl jointlist PIDList 3 0 fa2 s1 dt)
						))
					)
				)
			)
			nil
		)

		(if (XPhBodyGetKeyState this 38)	;L[ꂽꍇ
			(def ta (+ ta 0.03))
			nil
		)

		(if (XPhBodyGetKeyState this 40)	;L[ꂽꍇ
			(def ta (- ta 0.03))
			nil
		)

		(if (XPhBodyGetKeyState this 37)	;L[ꂽꍇ
			(def ta (+ ta 0.03))
			nil
		)

		(if (XPhBodyGetKeyState this 39)	;L[ꂽꍇ
			(def ta (- ta 0.03))
			nil
		)

		(if (XPhBodyGetKeyState this 65)	;AL[ꂽꍇ
			((lambda ()
				(XPhJointSetTorque (select (select jointlist 0) 1) 200)
				(XPhJointSetTorque (select (select jointlist 1) 1) 200)
				(XPhJointSetTorque (select (select jointlist 2) 1) 200)
				(XPhJointSetTorque (select (select jointlist 3) 1) 200)

				(XPhJointSetTorque (select (select jointlist 0) 2) -100)
				(XPhJointSetTorque (select (select jointlist 1) 2) -100)
				(XPhJointSetTorque (select (select jointlist 2) 2) -100)
				(XPhJointSetTorque (select (select jointlist 3) 2) -100)
				(def noinput nil)
			))
			nil
		)

		(if
			noinput
			(let*
				(
					(fa 50)
				)

				(XPhJointSetBrake (select (select jointlist 0) 0) 50)
				(XPhJointSetBrake (select (select jointlist 1) 0) 50)
				(XPhJointSetBrake (select (select jointlist 2) 0) 50)
				(XPhJointSetBrake (select (select jointlist 3) 0) 50)

				(XPhJointSetStaticFrictionCoeff (select (select jointlist 0) 0) 1)
				(XPhJointSetStaticFrictionCoeff (select (select jointlist 1) 0) 1)
				(XPhJointSetStaticFrictionCoeff (select (select jointlist 2) 0) 1)
				(XPhJointSetStaticFrictionCoeff (select (select jointlist 3) 0) 1)

				(XPhJointSetDynamicFrictionCoeff (select (select jointlist 0) 0) 1)
				(XPhJointSetDynamicFrictionCoeff (select (select jointlist 1) 0) 1)
				(XPhJointSetDynamicFrictionCoeff (select (select jointlist 2) 0) 1)
				(XPhJointSetDynamicFrictionCoeff (select (select jointlist 3) 0) 1)

				(JointPIDControl jointlist PIDList 0 2 fa (/ (PI) 2) dt)
				(JointPIDControl jointlist PIDList 1 2 fa (/ (PI) 2) dt)
				(JointPIDControl jointlist PIDList 2 2 fa (/ (PI) 2) dt)
				(JointPIDControl jointlist PIDList 3 2 fa (/ (PI) 2) dt)

				(JointPIDControl jointlist PIDList 0 1 fa (/ (PI) -2) dt)
				(JointPIDControl jointlist PIDList 1 1 fa (/ (PI) -2) dt)
				(JointPIDControl jointlist PIDList 2 1 fa (/ (PI) -2) dt)
				(JointPIDControl jointlist PIDList 3 1 fa (/ (PI) -2) dt)

				'(XPhJointSetTorque (select (select jointlist 0) 2) fa)
				'(XPhJointSetTorque (select (select jointlist 1) 2) fa)
				'(XPhJointSetTorque (select (select jointlist 2) 2) fa)
				'(XPhJointSetTorque (select (select jointlist 3) 2) fa)

				'(XPhJointSetTorque (select (select jointlist 0) 1) (- 0 fa))
				'(XPhJointSetTorque (select (select jointlist 1) 1) (- 0 fa))
				'(XPhJointSetTorque (select (select jointlist 2) 1) (- 0 fa))
				'(XPhJointSetTorque (select (select jointlist 3) 1) (- 0 fa))
			)
			nil
		)

		(if (XPhBodyGetKeyState this 69)	;EL[ꂽꍇ
			((lambda ()
				(XPhBodyAddForce this
					'(0 400 0)	;(VMul (select tMat 1) 400.0)
					(select tMat 3)	;(VAdd (select tMat 3) (select tMat 1))
				)
			))
			nil
		)

		(if (XPhBodyGetKeyState this 88)	;XL[ꂽꍇ
			((lambda ()
				(XPhBodyAddForce this
					'(0 -400 0)	;(VMul (select tMat 1) 400.0)
					(select tMat 3)	;(VAdd (select tMat 3) (VMul (select tMat 1) -1))
				)
			))
			nil
		)

		(if (XPhBodyGetKeyState this 67)	;CL[ꂽꍇ
			((lambda ()
				(XPhBodyAddAngularForce this
					'(0 200 0)
				)
			))
			nil
		)

		(if (XPhBodyGetKeyState this 90)	;ZL[ꂽꍇ
			((lambda ()
				(XPhBodyAddAngularForce this
					'(0 -200 0)
				)
			))
			nil
		)

		(if (XPhBodyGetKeyState this 73)	;IL[ꂽꍇ
			((lambda ()
				(XPhBodyAddForce this
					(VMul (select tMat 2) -200.0)
					(VAdd (select tMat 3) (VMul (select tMat 1) -1))
				)
			))
			nil
		)

		(if (XPhBodyGetKeyState this 77)	;ML[ꂽꍇ
			((lambda ()
				(XPhBodyAddForce this
					(VMul (select tMat 2) 200.0)
					(VAdd (select tMat 3) (VMul (select tMat 1) -1))
				)
			))
			nil
		)

		(if (XPhBodyGetKeyState this 74)	;JL[ꂽꍇ
			((lambda ()
				(XPhBodyAddForce this
					(VMul (select tMat 0) 200.0)
					(VAdd (select tMat 3) (VMul (select tMat 1) -1))
				)
			))
			nil
		)

		(if (XPhBodyGetKeyState this 75)	;KL[ꂽꍇ
			((lambda ()
				(XPhBodyAddForce this
					(VMul (select tMat 0) -200.0)
					(VAdd (select tMat 3) (VMul (select tMat 1) -1))
				)
			))
			nil
		)


		(if (XPhBodyGetKeyState this 83)	;SL[ꂽꍇ
			(def graspflg t)
			nil
		)

		(if (XPhBodyGetKeyState this VK_D)	;DL[ꂽꍇ
			(def graspflg nil)
			nil
		)

		(if graspflg
			(progn
				(XPhJointSetBrake (select (select jointlist 0) 0) 0)
				(XPhJointSetBrake (select (select jointlist 1) 0) 0)
				(XPhJointSetBrake (select (select jointlist 2) 0) 0)
				(XPhJointSetBrake (select (select jointlist 3) 0) 0)

				(XPhJointSetTorque (select (select jointlist 0) 0) 50)
				(XPhJointSetTorque (select (select jointlist 1) 0) -50)
				(XPhJointSetTorque (select (select jointlist 2) 0) -50)
				(XPhJointSetTorque (select (select jointlist 3) 0) 50)

				(XPhJointSetTorque (select (select jointlist 0) 1) 50)
				(XPhJointSetTorque (select (select jointlist 1) 1) 50)
				(XPhJointSetTorque (select (select jointlist 2) 1) 50)
				(XPhJointSetTorque (select (select jointlist 3) 1) 50)

				(XPhJointSetTorque (select (select jointlist 0) 2) 50)
				(XPhJointSetTorque (select (select jointlist 1) 2) 50)
				(XPhJointSetTorque (select (select jointlist 2) 2) 50)
				(XPhJointSetTorque (select (select jointlist 3) 2) 50)

				'(JointPIDControl jointlist PIDList 0 0 50 1 dt)
				'(JointPIDControl jointlist PIDList 1 0 50 1 dt)
				'(JointPIDControl jointlist PIDList 2 0 50 1 dt)
				'(JointPIDControl jointlist PIDList 3 0 50 1 dt)
			)
			nil
		)

		(if (XPhBodyGetKeyState this VK_B)	;BL[ꂽꍇ
			(def balancemode t)
			nil
		)

		(if (XPhBodyGetKeyState this VK_V)	;VL[ꂽꍇ
			(def balancemode nil)
			nil
		)

		(if balancemode
			((lambda ()
				(XPhBodyAddAngularForce this
					(list (* (select (select tMat 1) 2) -3000.0) 
						0 
						(* (select (select tMat 1) 0) 3000.0)
					)
				)
				
			))
			nil
		)

		(let*
			(
				(va '(0 0 0))
			)
			(def va (VAdd va '(0 1 0)))
			(def va (VAdd va (VAdd (select tMat 3) (VMul (select tMat 2) 8))))
			(def view (VAdd (VMul va 0.1)  (VMul view 0.9)))

			(def va '(0 1 0))
			(def va (VAdd va (VAdd (select tMat 3) (VMul (select tMat 2) -8))))
			(def vtarget (VAdd (VMul va 0.1)  (VMul vtarget 0.9)))

			(def va (select tMat 1))
			(def vup (VAdd (VMul va 0.2)  (VMul vup 0.8)))


			'(def tMat (GetXPhBodyMat this))
			'(def tMat (list (VMul (select tMat 0) -1) (select tMat 1)
					 (VMul (select tMat 2) -1)
					view)
			)

			(def tMat (LookAtMat vtarget view vup))

			(SetXPhCameraMat tMat)	;J̈ʒuݒ

			(def data (assoc_list_set data 'view_point view))
			(def data (assoc_list_set data 'view_target vtarget))
			(def data (assoc_list_set data 'view_up vup))
		)

		(def data (assoc_list_set data 'ta ta))
		(def data (assoc_list_set data 'balancemode balancemode))
		(def data (assoc_list_set data 'graspflg graspflg))
		(XPhBodySetData this data)

	)
)

(def crab (MakeCrab))


(defun JointPIDControl (JointList PIDList i j fa theta dt)
	(let*
		(
			(Joint (select (select JointList i) j))
			(PID (select (select PIDList i) j))
			(dtheta (XPhJointGetDTheta Joint))
		)
		(if theta
			(XPhPIDSetTarget PID theta)
			nil
		)
		(XPhPIDSetState PID (XPhJointGetTheta Joint))
		(XPhJointSetTorque Joint (- (* (XPhPIDStep PID dt) fa) 
					(* (* dtheta fa) 0.1)))

	)
)

(defun MakePID ()
	(let*
		(
			(PID (XPhPIDMake))
		)

		(XPhPIDSetOutPutRange PID -1 1)
		(XPhPIDSetParam PID 100 0.9 0.0)
		(XPhPIDSetState PID 0.0)
		PID
	)
)

(let*
	(
		(data (XPhBodyGetData crab))
		(PIDList
			(list
				(list (MakePID) (MakePID) (MakePID))
				(list (MakePID) (MakePID) (MakePID))
				(list (MakePID) (MakePID) (MakePID))
				(list (MakePID) (MakePID) (MakePID))
			)
		)
	)

	(def data (assoc_list_set data 'view_point '(0.0 0.0 10.0)))
	(def data (assoc_list_set data 'view_target '(0.0 0.0 -10.0)))
	(def data (assoc_list_set data 'view_up '(0.0 1.0 0.0)))
	(def data (assoc_list_set data 'ta 0.0))
	(def data (assoc_list_set data 'balancemode nil))
	
	(def data (assoc_list_set data 'PIDs PIDList))
	(def data (assoc_list_set data 'graspflg nil))

	(XPhBodySetData crab data)
)

(XPhBodySetFunction crab CrabFunction)

(defun makeboxsandcons (x num)
	(SetXPhBodyMat x (list '(1 0 0) '(0 1 0)
			'(0 0 1) (list -10 (+ 32 (* 2 num)) -10)))
	;(ScaleAndResetBoxInertiaTensor x 0.75)
	(cons x (makeboxs (- num 1)))
)

(defun makeboxs (num)
	(if (= num 0)
		nil
		(makeboxsandcons (LoadXPhBody "lbox.x") num)
	)
)

(def boxs (makeboxs 5))


(def egg (LoadXPhBody "egg.x"))
(SetXPhBodyMat egg (list '(1 0 0) '(0 1 0)
			'(0 0 1) '(10 10 -10)))
(ScaleAndResetBoxInertiaTensor egg 1.5)

(def xbox (LoadXPhBody "xbox.x"))
(SetXPhBodyMat xbox (list '(1 0 0) '(0 1 0)
			'(0 0 1) '(0 10 -10)))
(ScaleAndResetBoxInertiaTensor xbox 0.75)

(def f22 (LoadXPhBody "f22.x"))
(SetXPhBodyMat f22 (list '(1 0 0) '(0 1 0)
			'(0 0 1) '(10 10 0)))
(ScaleAndResetBoxInertiaTensor f22 1.5)


(XPhBodyGetFuncResult crab)

