;Cu̓ǂݍ
(Load "defaultlisplib.lsp")
(Load "ph3dlib.lsp")

;΂ˌWȂǂ̃p[^̏
(PhDefaultParamSetUp)
'(SetCollisionSpringCoeff 100.0)

;Î~CW̐ݒ
(SetCollisionStaticFrictionCoeff 0.8)

;CW̐ݒ
(SetCollisionDynamicFrictionCoeff 0.7)

;̌`t@C̓ǂݍ
(def x (LoadXPhBody "gfloor.x"))
(PhSetUpForFixedObject x)
(SetXPhBodyMat x '((1 0 0) (0 1 0) (0 0 1) (0 -5 0)))
(SetXPhVertexTransformMat x '((5 0 0) (0 5 0) (0 0 5) (0 0 0)))
(XPhBodySetVisualMaterial x '((1 1 1 1) (0.5 0.5 0.5 0.5) (0 0 0 0) 0))

;I^{bgǂݍ
(Load "LispCrab.lsp")


(defun CrabFunction (this)
	(let*
		(
			(data (XPhBodyGetData this))
			(jointlist (assoc_list_search data 'joints))
			(t (assoc_list_search data 'ta))
		)

		(XPhJointSetMinTheta (select (select jointlist 0) 2) 0)
		(XPhJointSetMinTheta (select (select jointlist 1) 2) 0)
		(XPhJointSetMinTheta (select (select jointlist 2) 2) 0)
		(XPhJointSetMinTheta (select (select jointlist 3) 2) 0)

		(if (< t 2.0)
			(let*
				(
					(fa 50)
				)

				(XPhJointSetBrake (select (select jointlist 0) 0) 50)
				(XPhJointSetBrake (select (select jointlist 1) 0) 50)
				(XPhJointSetBrake (select (select jointlist 2) 0) 50)
				(XPhJointSetBrake (select (select jointlist 3) 0) 50)

				(XPhJointSetStaticFrictionCoeff (select (select jointlist 0) 0) 100)
				(XPhJointSetStaticFrictionCoeff (select (select jointlist 1) 0) 100)
				(XPhJointSetStaticFrictionCoeff (select (select jointlist 2) 0) 100)
				(XPhJointSetStaticFrictionCoeff (select (select jointlist 3) 0) 100)

				(XPhJointSetDynamicFrictionCoeff (select (select jointlist 0) 0) 100)
				(XPhJointSetDynamicFrictionCoeff (select (select jointlist 1) 0) 100)
				(XPhJointSetDynamicFrictionCoeff (select (select jointlist 2) 0) 100)
				(XPhJointSetDynamicFrictionCoeff (select (select jointlist 3) 0) 100)

				(XPhJointSetTorque (select (select jointlist 0) 2) fa)
				(XPhJointSetTorque (select (select jointlist 1) 2) fa)
				(XPhJointSetTorque (select (select jointlist 2) 2) fa)
				(XPhJointSetTorque (select (select jointlist 3) 2) fa)

				(XPhJointSetTorque (select (select jointlist 0) 1) (- 0 fa))
				(XPhJointSetTorque (select (select jointlist 1) 1) (- 0 fa))
				(XPhJointSetTorque (select (select jointlist 2) 1) (- 0 fa))
				(XPhJointSetTorque (select (select jointlist 3) 1) (- 0 fa))
			)
			(let*
				(
					(fa 100)
					(fa2 300)
					(sa 
						'(lambda (t) ()
							(if (< (sin t) 0)
								(+ 0.75 (sin t))
								0.75
							)
						)
					)
					(t0 (sa t))
					(t1 (sa (+ t (PI))))
					;(t0 (sin t))
					;(t1 (sin (+ t (PI))))
					(s0 (sin t))
					(s1 (sin (+ t (PI))))
				)

				(XPhJointSetBrake (select (select jointlist 0) 0) 0)
				(XPhJointSetBrake (select (select jointlist 1) 0) 0)
				(XPhJointSetBrake (select (select jointlist 2) 0) 0)
				(XPhJointSetBrake (select (select jointlist 3) 0) 0)

				(XPhJointSetStaticFrictionCoeff (select (select jointlist 0) 0) 0)
				(XPhJointSetStaticFrictionCoeff (select (select jointlist 1) 0) 0)
				(XPhJointSetStaticFrictionCoeff (select (select jointlist 2) 0) 0)
				(XPhJointSetStaticFrictionCoeff (select (select jointlist 3) 0) 0)

				(XPhJointSetDynamicFrictionCoeff (select (select jointlist 0) 0) 0)
				(XPhJointSetDynamicFrictionCoeff (select (select jointlist 1) 0) 0)
				(XPhJointSetDynamicFrictionCoeff (select (select jointlist 2) 0) 0)
				(XPhJointSetDynamicFrictionCoeff (select (select jointlist 3) 0) 0)


				(XPhJointSetTorque (select (select jointlist 0) 2)
							(* fa t0))
				(XPhJointSetTorque (select (select jointlist 1) 2)
							(* fa t1))
				(XPhJointSetTorque (select (select jointlist 2) 2)
							(* fa t1))
				(XPhJointSetTorque (select (select jointlist 3) 2)
							(* fa t0))

				(XPhJointSetTorque (select (select jointlist 0) 1) (- 0 fa))
				(XPhJointSetTorque (select (select jointlist 1) 1) (- 0 fa))
				(XPhJointSetTorque (select (select jointlist 2) 1) (- 0 fa))
				(XPhJointSetTorque (select (select jointlist 3) 1) (- 0 fa))

				(XPhJointSetTorque (select (select jointlist 0) 0)
							(* fa2 s0))
				(XPhJointSetTorque (select (select jointlist 1) 0)
							(* fa2 s1))
				(XPhJointSetTorque (select (select jointlist 2) 0)
							(* fa2 s0))
				(XPhJointSetTorque (select (select jointlist 3) 0)
							(* fa2 s1))
			)
		)

		(def t (+ t 0.01))

		(if (XPhBodyGetKeyState this 83)	;sL[ꂽꍇ
			((lambda ()
				(XPhJointSetTorque (select (select jointlist 0) 2) -2)
			))
			nil
		)

		(def data (assoc_list_set data 'ta t))
		(XPhBodySetData this data)

	)
)

(def crab (MakeCrab))

(let*
	(
		(data (XPhBodyGetData crab))
	)

	(def data (assoc_list_set data 'ta 0.0))
	(XPhBodySetData crab data)
)

(XPhBodySetFunction crab CrabFunction)


(def camera_manager (MakeEmptyXPhBody))

(defun func (this)
	(let*
		(
			(data (XPhBodyGetData this))
			(theta (car data))
			(phi (car (cdr data)))
			(va '(0 0 0))
		)

		(if (XPhBodyGetKeyState this 37)	;L[ꂽꍇ
			(def theta (+ theta 0.05))
			nil
		)

		(if (XPhBodyGetKeyState this 39)	;L[ꂽꍇ
			(def theta (+ theta -0.05))
			nil
		)

		(if (XPhBodyGetKeyState this 38)	;L[ꂽꍇ
			(def phi (+ phi 0.05))
			nil
		)

		(if (XPhBodyGetKeyState this 40)	;L[ꂽꍇ
			(def phi (+ phi -0.05))
			nil
		)

		(def va (list 
				(* (cos theta) (cos phi))
				(sin phi)
				(* (sin theta) (cos phi))
			)
		)

		(def va (VMul va 10))

		(SetXPhCameraMat (LookAtMat '(0 0 0) va '(0 1 0)))

		(XPhBodySetData this (list theta phi))

	)

)

(XPhBodySetData camera_manager '(0 0))

(XPhBodySetFunction camera_manager
		func
)


(XPhBodyGetFuncResult camera_manager)


