;Cu̓ǂݍ
(Load "defaultlisplib.lsp")
(Load "ph3dlib.lsp")

(XPhSet_EasyViewText 
	(strcat
		"LispSource/\nLispCrabWalk.lsp\n"
		"J[\L[ŃJ]\n"
		"E,XőOɈړ\n"
	)
)

(XPhFogEnable t)
(XPhBgColor 200 200 203)

;΂ˌWȂǂ̃p[^̏
(PhDefaultParamSetUp)
'(SetCollisionSpringCoeff 100.0)

;Î~CW̐ݒ
(SetCollisionStaticFrictionCoeff 0.8)

;CW̐ݒ
(SetCollisionDynamicFrictionCoeff 0.7)

;̌`t@C̓ǂݍ
(def x (LoadXPhBody "road.x"))
(PhSetUpForFixedObject x)
(SetXPhBodyMat x '((1 0 0) (0 1 0) (0 0 1) (0 -5 0)))
(SetXPhVertexTransformMat x '((5 0 0) (0 5 0) (0 0 5) (0 0 0)))
(XPhBodySetVisualMaterial x '((1 1 1 1) (0.5 0.5 0.5 0.5) (0 0 0 0) 0))

;I^{bgǂݍ
(Load "LispCrab.lsp")


(defun CrabFunction (this)
	(let*
		(
			(data (XPhBodyGetData this))
			(jointlist (assoc_list_search data 'joints))
			(PIDList (assoc_list_search data 'PIDs))
			(tt (assoc_list_search data 'ta))
			(dt (GetSimulationStepSize))
		)

		(XPhJointSetMinTheta (select (select jointlist 0) 2) 0)
		(XPhJointSetMinTheta (select (select jointlist 1) 2) 0)
		(XPhJointSetMinTheta (select (select jointlist 2) 2) 0)
		(XPhJointSetMinTheta (select (select jointlist 3) 2) 0)

		(if (< tt 4.0)
			(let*
				(
					(fa 50)
				)

				(XPhJointSetBrake (select (select jointlist 0) 0) 50)
				(XPhJointSetBrake (select (select jointlist 1) 0) 50)
				(XPhJointSetBrake (select (select jointlist 2) 0) 50)
				(XPhJointSetBrake (select (select jointlist 3) 0) 50)

				(XPhJointSetStaticFrictionCoeff (select (select jointlist 0) 0) 100)
				(XPhJointSetStaticFrictionCoeff (select (select jointlist 1) 0) 100)
				(XPhJointSetStaticFrictionCoeff (select (select jointlist 2) 0) 100)
				(XPhJointSetStaticFrictionCoeff (select (select jointlist 3) 0) 100)

				(XPhJointSetDynamicFrictionCoeff (select (select jointlist 0) 0) 100)
				(XPhJointSetDynamicFrictionCoeff (select (select jointlist 1) 0) 100)
				(XPhJointSetDynamicFrictionCoeff (select (select jointlist 2) 0) 100)
				(XPhJointSetDynamicFrictionCoeff (select (select jointlist 3) 0) 100)

				(XPhJointSetTorque (select (select jointlist 0) 2) fa)
				(XPhJointSetTorque (select (select jointlist 1) 2) fa)
				(XPhJointSetTorque (select (select jointlist 2) 2) fa)
				(XPhJointSetTorque (select (select jointlist 3) 2) fa)

				(XPhJointSetTorque (select (select jointlist 0) 1) (- 0 fa))
				(XPhJointSetTorque (select (select jointlist 1) 1) (- 0 fa))
				(XPhJointSetTorque (select (select jointlist 2) 1) (- 0 fa))
				(XPhJointSetTorque (select (select jointlist 3) 1) (- 0 fa))
			)
			(let*
				(
					(fa 100)
					(fa2 200)
					(fa3 50)
					(sa 
						'(lambda (tt) ()
							(if (< (sin tt) 0)
								(+ 1.0 (* (sin tt) 1.0))
								1.0
							)
						)
					)
					(t0 (* (sa tt) (* 0.5 (PI))))
					(t1 (* (sa (+ tt (PI))) (* 0.5 (PI))) )
					;(t0 (sin tt))
					;(t1 (sin (+ tt (PI))))
					(s0 (* (sin tt) (* 0.15 (PI)) ) )
					(s1 (*  (sin (+ tt (PI))) (* 0.15 (PI)) ) ) 
				)

				(XPhJointSetBrake (select (select jointlist 0) 0) 0)
				(XPhJointSetBrake (select (select jointlist 1) 0) 0)
				(XPhJointSetBrake (select (select jointlist 2) 0) 0)
				(XPhJointSetBrake (select (select jointlist 3) 0) 0)

				(XPhJointSetStaticFrictionCoeff (select (select jointlist 0) 0) 0)
				(XPhJointSetStaticFrictionCoeff (select (select jointlist 1) 0) 0)
				(XPhJointSetStaticFrictionCoeff (select (select jointlist 2) 0) 0)
				(XPhJointSetStaticFrictionCoeff (select (select jointlist 3) 0) 0)

				(XPhJointSetDynamicFrictionCoeff (select (select jointlist 0) 0) 0)
				(XPhJointSetDynamicFrictionCoeff (select (select jointlist 1) 0) 0)
				(XPhJointSetDynamicFrictionCoeff (select (select jointlist 2) 0) 0)
				(XPhJointSetDynamicFrictionCoeff (select (select jointlist 3) 0) 0)

				(JointPIDControl jointlist PIDList 0 2 fa t0 dt)
				(JointPIDControl jointlist PIDList 1 2 fa t1 dt)
				(JointPIDControl jointlist PIDList 2 2 fa t1 dt)
				(JointPIDControl jointlist PIDList 3 2 fa t0 dt)

				(XPhJointSetTorque (select (select jointlist 0) 1) (- 0 fa3))
				(XPhJointSetTorque (select (select jointlist 1) 1) (- 0 fa3))
				(XPhJointSetTorque (select (select jointlist 2) 1) (- 0 fa3))
				(XPhJointSetTorque (select (select jointlist 3) 1) (- 0 fa3))

				(JointPIDControl jointlist PIDList 0 0 fa2 s0 dt)
				(JointPIDControl jointlist PIDList 1 0 fa2 s1 dt)
				(JointPIDControl jointlist PIDList 2 0 fa2 s0 dt)
				(JointPIDControl jointlist PIDList 3 0 fa2 s1 dt)
			)
		)

		(def tt (+ tt 0.03))

		(if (XPhBodyGetKeyState this 83)	;sL[ꂽꍇ
			((lambda ()
				(XPhJointSetTorque (select (select jointlist 0) 2) -2)
			))
			nil
		)

		(def data (assoc_list_set data 'ta tt))
		(XPhBodySetData this data)

	)
)

(def crab (MakeCrab))


(defun JointPIDControl (JointList PIDList i j fa theta dt)
	(let*
		(
			(Joint (select (select JointList i) j))
			(PID (select (select PIDList i) j))
			(dtheta (XPhJointGetDTheta Joint))
		)
		(if theta
			(XPhPIDSetTarget PID theta)
			nil
		)
		(XPhPIDSetState PID (XPhJointGetTheta Joint))
		(XPhJointSetTorque Joint (- (* (XPhPIDStep PID dt) fa) 
					(* (* dtheta fa) 0.1)))

	)
)

(defun MakePID ()
	(let*
		(
			(PID (XPhPIDMake))
		)

		(XPhPIDSetOutPutRange PID -1 1)
		(XPhPIDSetParam PID 100 0.9 0.0)
		(XPhPIDSetState PID 0.0)
		PID
	)
)

(let*
	(
		(data (XPhBodyGetData crab))
		(PIDList
			(list
				(list (MakePID) (MakePID) (MakePID))
				(list (MakePID) (MakePID) (MakePID))
				(list (MakePID) (MakePID) (MakePID))
				(list (MakePID) (MakePID) (MakePID))
			)
		)
	)

	(def data (assoc_list_set data 'ta 0.0))

	(def data (assoc_list_set data 'PIDs PIDList))

	(XPhBodySetData crab data)
)

(XPhBodySetFunction crab CrabFunction)


(def camera_manager (MakeEmptyXPhBody))

(defun func (this)
	(let*
		(
			(data (XPhBodyGetData this))
			(theta (car data))
			(phi (car (cdr data)))
			(x (select data 2))
			(y (select data 3))
			(va '(0 0 0))
		)

		(if (XPhBodyGetKeyState this 37)	;L[ꂽꍇ
			(def theta (+ theta 0.05))
			nil
		)

		(if (XPhBodyGetKeyState this 39)	;L[ꂽꍇ
			(def theta (+ theta -0.05))
			nil
		)

		(if (XPhBodyGetKeyState this 38)	;L[ꂽꍇ
			(def phi (+ phi 0.05))
			nil
		)

		(if (XPhBodyGetKeyState this 40)	;L[ꂽꍇ
			(def phi (+ phi -0.05))
			nil
		)

		(if (XPhBodyGetKeyState this 69)	;EL[ꂽꍇ
			((lambda ()
				(def x (- x (* (* (cos theta) (cos phi)) 0.1)))
				(def y (- y (* (* (sin theta) (cos phi)) 0.1)))
			))
			nil
		)

		(if (XPhBodyGetKeyState this 88)	;XL[ꂽꍇ
			((lambda ()
				(def x (+ x (* (* (cos theta) (cos phi)) 0.1)))
				(def y (+ y (* (* (sin theta) (cos phi)) 0.1)))
			))
			nil
		)

		'(if (XPhBodyGetKeyState this 88)	;XL[ꂽꍇ
			((lambda ()
				(def x (+ x (* (* (sin theta) (cos phi)) 0.1)))
				(def y (- y (* (* (cos theta) (cos phi)) 0.1)))
			))
			nil
		)

		(def va (list 
				(* (cos theta) (cos phi))
				(sin phi)
				(* (sin theta) (cos phi))
			)
		)

		(def va (VMul va 10))
		(def va (list (+ (select va 0) x) (select va 1) (+ (select va 2) y)))

		(SetXPhCameraMat (LookAtMat (list x 0 y) va '(0 1 0)))

		(XPhBodySetData this (list theta phi x y))

	)

)

(XPhBodySetData camera_manager '(0 0 0 0))

(XPhBodySetFunction camera_manager
		func
)


(XPhBodyGetFuncResult camera_manager)
(XPhBodyGetFuncResult crab)

