;Cu̓ǂݍ
(Load "defaultlisplib.lsp")
(Load "ph3dlib.lsp")

(defun MakeCraneTire (body dir up st offset)
	(let*
		(
			(data (XPhBodyGetData body))
			(jointlist (assoc_list_search data 'joints))
			(tire (LoadXPhBody "tireld.x"))
			(scale 0.25)

			(mat (GetXPhBodyMat body))
			(cp (VCross dir up))
			(ma nil)
			(sta (VAdd st (select mat 3)))
		)

		(LoadXPhBodyVisual tire "tire.x")
		(XPhBodySetMass tire 1.0)
		(XPhBodySetVisualMaterial tire '((1 1 1 1) (0.5 0.5 0.5 0.5) (0 0 0 0) 0))
		(ScaleAndResetBoxInertiaTensor tire scale)
		
		(SetXPhVertexTransformMat tire 
			(AppendMatVec 
				(YRotMat (* -0.5 (PI)))
				'(0 0 0)
			)
		)

		(def ma (LookAtMat (VAdd sta cp) sta up))

		(SetXPhBodyMat tire ma)

		(let*
			(
				(jnt (XPhBodyAddJointChild body tire
					 (VAdd st offset)
						dir up (* 1.25 scale)))
			)

			(PhSetUpDefaultJointParam jnt body tire)
			(XPhJointSetRotationalDamper jnt 0.2)
			'(XPhBodyJointSpringCoeff jnt 1000.0)
			'(XPhBodyJointSpringDamper jnt 4.5)

			(XPhBodyJointLimitFlag jnt nil)


			(def data (assoc_list_set data 'joints 
				(cons jnt jointlist))
			)

			(XPhBodySetData body data)
		)

		tire
	)
)

(defun MakeCraneArm (body)
	(let*
		(
			(data (XPhBodyGetData body))
			(craw (LoadXPhBody "ucrow.x"))
			(craw2 (LoadXPhBody "ucrow.x"))
			(arm (LoadXPhBody "dleg.x"))

			(mat (GetXPhBodyMat body))
			(sta (select mat 3))
		)

		(SetXPhBodyMat craw 
				(list '(1 0 0) '(0 1 0) '(0 0 1)
					(VAdd '(0.1 3 0.5) sta))
		)
		(XPhBodySetMass craw 0.5)
		(ScaleAndResetBoxInertiaTensor craw 0.5)

		(SetXPhBodyMat craw2 
				(AppendMatVec
					(YRotMat (PI))
					(VAdd '(-0.1 3 0.5) sta))
		)
		(XPhBodySetMass craw2 0.5)
		(ScaleAndResetBoxInertiaTensor craw2 0.5)

		(SetXPhBodyMat arm (list '(-1 0 0) '(0 1 0) '(0 0 -1) (VAdd '(0 2 0.5) sta)))

		(def j0 (PhMakeJointWithGuessParam arm craw 
				'(0.0 1.0 0.0)
				'(0 0 1)
				'(0 1 0)
		))

		(def j1 (PhMakeJointWithGuessParam arm craw2 
				'(0.0 1.0 0.0)
				'(0 0 1)
				'(0 1 0)
		))

		(def j2 (PhMakeJointWithGuessParam body arm 
				'(0.0 1.0 0.5)
				'(1 0 0)
				'(0 1 0)
		))

		(XPhJointSetMaxTheta j0 (* (PI) 0.15))
		(XPhJointSetMinTheta j1 (* (PI) -0.15))

		(XPhJointSetMinTheta j2 (* (PI) 0.0))

		;(XPhJointSetMinTheta j0 (* (PI) 0.0))
		;(XPhJointSetMaxTheta j1 (* (PI) -0.0))

		;(PhSetUpDefaultJointParam j0)
		;(PhSetUpDefaultJointParam j1)

		;(XPhBodyJointSpringDamper j0 0.001)
		;(XPhBodyJointSpringDamper j1 0.001)
		;(XPhJointSetRotationalDamper j0 50.0)
		;(XPhJointSetRotationalDamper j1 50.0)

		(XPhJointSetRotationalDamper j2 12.0)

		(def data (assoc_list_set data 'armjoints 
				(list j2 j0 j1))
			)
		(XPhBodySetData body data)
	)

)


(defun MakeCraneAutoMobile ()
	(let*
		(
			(AutoMobile (LoadXPhBody "kbody_ld.x"))
		)

		(LoadXPhBodyVisual AutoMobile "kbody.x")
		(SetXPhBodyMat AutoMobile '((1 0 0) (0 1 0) (0 0 1) (0 5 0)))
		(SetXPhVertexTransformMat AutoMobile 
			(AppendMatVec 
				(MatMul
					(XRotMat (* -0.5 (PI)))
					(YRotMat (PI))
				)
				'(0 0.25 -1)
			)
		)

		(XPhBodySetMass AutoMobile 4.0)
		(ScaleAndResetBoxInertiaTensor AutoMobile 1.0)

		(XPhBodySetData AutoMobile nil)

		(MakeCraneTire AutoMobile '(1 0 0) '(0 1 0)
				'(1.25 -0.65 1.35) '(-0.25 0 0))
		(MakeCraneTire AutoMobile '(1 0 0) '(0 1 0)
				'(1.25 -0.65 -1.35) '(-0.25 0 0))
		(MakeCraneTire AutoMobile '(1 0 0) '(0 1 0)
				'(-1.25 -0.65 1.35) '(0.25 0 0))
		(MakeCraneTire AutoMobile '(1 0 0) '(0 1 0)
				'(-1.25 -0.65 -1.35) '(0.25 0 0))

		(MakeCraneArm AutoMobile)
		AutoMobile
	)
)
