(Load "LispCraneAuto.lsp")
(PhDefaultParamSetUp)

(XPhSet_EasyViewText 
	(strcat
		"Sł\n"
		"Dŗ\n"
		"J[\L[ňړ\n"
	)
)

;AXt@g - S
;Î~CW̐ݒ
(SetCollisionStaticFrictionCoeff 0.8)

;CW̐ݒ
(SetCollisionDynamicFrictionCoeff 0.55)

(def CraneAutoMobile (MakeCraneAutoMobile))

(let*
	(
		(data (XPhBodyGetData CraneAutoMobile))
	)

	(def data (assoc_list_set data 'view_point '(0.0 0.0 -10.0)))

	(XPhBodySetData CraneAutoMobile data)
)

(defun CraneAutoMobileFunc (this)
	(let*
		(
			(data (XPhBodyGetData this))
			(jointlist (assoc_list_search data 'joints))
			(armjointlist (assoc_list_search data 'armjoints))
			(view (assoc_list_search data 'view_point))
			(tMat (GetXPhBodyMat this))
			(axel 55.0)
			(j0ax 0.0) (j1ax 0.0) (j2ax 0.0) (j3ax 0.0)
		)

		

		(if (XPhBodyGetKeyState this 38)	;L[ꂽꍇ
			((lambda ()
				(def j0ax (+ j0ax axel))
				(def j1ax (+ j1ax axel))
				(def j2ax (+ j2ax axel))
				(def j3ax (+ j3ax axel))

				;gN̑ł
				(XPhBodyAddAngularForce this
					(VMul (select tMat 0) (* axel 4)))
			))
			nil
		)

		(if (XPhBodyGetKeyState this 40)	;L[ꂽꍇ
			((lambda ()
				(def j0ax (+ j0ax (- 0 axel)))
				(def j1ax (+ j1ax (- 0 axel)))
				(def j2ax (+ j2ax (- 0 axel)))
				(def j3ax (+ j3ax (- 0 axel)))

				;gN̑ł
				(XPhBodyAddAngularForce this
					(VMul (select tMat 0) (* axel -4)))
			))
			nil
		)


		(if (XPhBodyGetKeyState this 37)	;L[ꂽꍇ
			((lambda ()
				(def j0ax (+ j0ax (- 0 axel)))
				(def j1ax (+ j1ax (- 0 axel)))
				(def j2ax (+ j2ax axel))
				(def j3ax (+ j3ax axel))
			))
			nil
		)

		(if (XPhBodyGetKeyState this 39)	;L[ꂽꍇ
			((lambda ()
				(def j0ax (+ j0ax axel))
				(def j1ax (+ j1ax axel))
				(def j2ax (+ j2ax (- 0 axel)))
				(def j3ax (+ j3ax (- 0 axel)))
				
			))
			nil
		)

		(if (XPhBodyGetKeyState this 88)	;xL[ꂽꍇ
			((lambda ()
				(XPhBodyAddForce this
						'(0 1 0)
						(VAdd 
							(select tMat 3)
							(VMul (select tMat 1) 10.0)
						)
				)	;pۂ߂ɏdS荂ʒuɕオ͂
				(XPhBodyAddLinearForce this '(0 400 0))	;㏸
			))
			nil
		)

		(if (XPhBodyGetKeyState this VK_D)
			((lambda ()
				(XPhJointSetTorque (select armjointlist 0) 100.0)
				(XPhJointSetTorque (select armjointlist 1) 60.0)
				(XPhJointSetTorque (select armjointlist 2) -60.0)
			))
			nil
		)

		(if (XPhBodyGetKeyState this VK_S)
			((lambda ()
				(XPhJointSetTorque (select armjointlist 0) 100.0)
				(XPhJointSetTorque (select armjointlist 1) -60.0)
				(XPhJointSetTorque (select armjointlist 2) 60.0)
			))
			nil
		)


		((lambda ()
			(XPhJointSetTorque (select jointlist 0) j0ax)
			(XPhJointSetTorque (select jointlist 1) j1ax)
			(XPhJointSetTorque (select jointlist 2) j2ax)
			(XPhJointSetTorque (select jointlist 3) j3ax)
		))

		(let*
			(
				(tMat (GetXPhBodyMat this))	
					;̊֐蓖ĂĂ镨̂̈ʒu擾
				(va '(0 0 0))
			)
			(def va (VAdd va '(0 8 0)))
			(def va (VAdd va (VAdd (select tMat 3) (VMul (select tMat 2) -12))))
			(def view (VAdd (VMul va 0.1)  (VMul view 0.9)))
			(def tMat (GetXPhBodyMat this))
			(def tMat (list (select tMat 0) (select tMat 1)
					 (select tMat 2) 
					view)
			)
			(SetXPhCameraMat tMat)	;J̈ʒuݒ

			(def data (assoc_list_set data 'view_point view))
			(XPhBodySetData this data)
		)
	)
)

(XPhBodySetFunction CraneAutoMobile CraneAutoMobileFunc)


(def CraneAutoMobile2 (MakeCraneAutoMobile))
(SetXPhBodyMat CraneAutoMobile2 '((1 0 0) (0 1 0) (0 0 1) (5 0 5)))



(def mono (LoadXPhBody "dleg.x"))
(SetXPhVertexTransformMat mono '((1.7 0 0) (0 1.7 0) (0 0 1.7) (0 0 0)))
(SetXPhBodyMat mono '((1 0 0) (0 1 0) (0 0 1) (0 0 5)))



(SetXPhSimulationFlag nil)
(SetXPhSimulationFlag t)


(def floor (LoadXPhBody "gfloor.x"))
(PhSetUpForFixedObject floor)
(SetXPhBodyMat floor '((1 0 0) (0 1 0) (0 0 1) (0 -5 0)))
(SetXPhVertexTransformMat floor '((5 0 0) (0 5 0) (0 0 5) (0 0 0)))
(SetXPhCameraMat '((1 0 0) (0 1 0) (0 0 1) (0 -2.5 -10)))


'(load "RotationalCamera.lsp")	;J[\L[E,XL[őłJ̐ݒ
				;camera_managerɃJ̕ϐ
'(SetEditChara camera_manager)	;ҏWɂLN^̐ݒ
