;Cu̓ǂݍ
(Load "defaultlisplib.lsp")
(Load "ph3dlib.lsp")

(XPhFogEnable t)
(XPhBgColor 230 230 233)

;΂ˌWȂǂ̃p[^̏
(PhDefaultParamSetUp)
'(SetCollisionSpringCoeff 220.0)
'(SetCollisionReboundCoeff 0.0)
'(SetCollisionVerticalDamperCoeff 1.0)
'(SetCollisionHorizontalDamperCoeff 2.0f)

;Î~CW̐ݒ
(SetCollisionStaticFrictionCoeff 1.8)

;CW̐ݒ
(SetCollisionDynamicFrictionCoeff 1.7)

;̌`t@C̓ǂݍ
(def floor (LoadXPhBody "pala.x"))
'(def floor (LoadXPhBody "gfloor.x"))
(PhSetUpForFixedObject floor)
(SetXPhBodyMat floor '((1 0 0) (0 1 0) (0 0 1) (0 -5 0)))
(SetXPhVertexTransformMat floor '((7 0 0) (0 7 0) (0 0 7) (0 0 0)))
(XPhBodySetVisualMaterial floor '((1 1 1 1) (0.5 0.5 0.5 0.5) (0 0 0 0) 0))

;x^̕
(def xobj (LoadXPhBody "xbox.x"))
(SetXPhBodyMat xobj '((1 0 0) (0 1 0) (0 0 1) (0 5 10)))

(def ball (LoadXPhBody "mbox.x"))
(SetXPhBodyMat ball '((1 0 0) (0 1 0) (0 0 1) (0 10 10)))


;I^{bgǂݍ
(Load "LispAutoMobile.lsp")

(def AutoMobile (MakeAutoMobile))

(let*
	(
		(data (XPhBodyGetData AutoMobile))
	)

	(def data (assoc_list_set data 'view_point '(0.0 0.0 -10.0)))

	(XPhBodySetData AutoMobile data)
)

(defun AutoMobileFunc (this)
	(let*
		(
			(data (XPhBodyGetData this))
			(jointlist (assoc_list_search data 'joints))
			(view (assoc_list_search data 'view_point))
			(tMat (GetXPhBodyMat this))
			(axel 25.0)
			(j0ax 0.0) (j1ax 0.0) (j2ax 0.0) (j3ax 0.0)
		)

		

		(if (XPhBodyGetKeyState this 38)	;L[ꂽꍇ
			((lambda ()
				(def j0ax (+ j0ax axel))
				(def j1ax (+ j1ax axel))
				(def j2ax (+ j2ax axel))
				(def j3ax (+ j3ax axel))

				;gN̑ł
				(XPhBodyAddAngularForce this
					(VMul (select tMat 0) (* axel 4)))
			))
			nil
		)

		(if (XPhBodyGetKeyState this 40)	;L[ꂽꍇ
			((lambda ()
				(def j0ax (+ j0ax (- 0 axel)))
				(def j1ax (+ j1ax (- 0 axel)))
				(def j2ax (+ j2ax (- 0 axel)))
				(def j3ax (+ j3ax (- 0 axel)))

				;gN̑ł
				(XPhBodyAddAngularForce this
					(VMul (select tMat 0) (* axel -4)))
			))
			nil
		)


		(if (XPhBodyGetKeyState this 37)	;L[ꂽꍇ
			((lambda ()
				(def j0ax (+ j0ax (- 0 axel)))
				(def j1ax (+ j1ax (- 0 axel)))
				(def j2ax (+ j2ax axel))
				(def j3ax (+ j3ax axel))
			))
			nil
		)

		(if (XPhBodyGetKeyState this 39)	;L[ꂽꍇ
			((lambda ()
				(def j0ax (+ j0ax axel))
				(def j1ax (+ j1ax axel))
				(def j2ax (+ j2ax (- 0 axel)))
				(def j3ax (+ j3ax (- 0 axel)))
				
			))
			nil
		)

		(if (XPhBodyGetKeyState this 88)	;xL[ꂽꍇ
			((lambda ()
				(XPhBodyAddForce this
						'(0 1 0)
						(VAdd 
							(select tMat 3)
							(VMul (select tMat 1) 10.0)
						)
				)	;pۂ߂ɏdS荂ʒuɕオ͂
				(XPhBodyAddLinearForce this '(0 400 0))	;㏸
			))
			nil
		)


		((lambda ()
			(XPhJointSetTorque (select jointlist 0) j0ax)
			(XPhJointSetTorque (select jointlist 1) j1ax)
			(XPhJointSetTorque (select jointlist 2) j2ax)
			(XPhJointSetTorque (select jointlist 3) j3ax)
		))

		(let*
			(
				(tMat (GetXPhBodyMat this))	
					;̊֐蓖ĂĂ镨̂̈ʒu擾
				(va '(0 0 0))
			)
			(def va (VAdd va '(0 2 0)))
			(def va (VAdd va (VAdd (select tMat 3) (VMul (select tMat 2) -6))))
			(def view (VAdd (VMul va 0.1)  (VMul view 0.9)))
			(def tMat (GetXPhBodyMat this))
			(def tMat (list (select tMat 0) (select tMat 1)
					 (select tMat 2) 
					view)
			)
			(SetXPhCameraMat tMat)	;J̈ʒuݒ

			(def data (assoc_list_set data 'view_point view))
			(XPhBodySetData AutoMobile data)
		)
	)
)

(XPhBodySetFunction AutoMobile AutoMobileFunc)



(def camera_manager (MakeEmptyXPhBody))

(defun func (this)
	(let*
		(
			(data (XPhBodyGetData this))
			(theta (car data))
			(phi (car (cdr data)))
			(x (select data 2))
			(y (select data 3))
			(va '(0 0 0))
		)

		(if (XPhBodyGetKeyState this 37)	;L[ꂽꍇ
			(def theta (+ theta 0.05))
			nil
		)

		(if (XPhBodyGetKeyState this 39)	;L[ꂽꍇ
			(def theta (+ theta -0.05))
			nil
		)

		(if (XPhBodyGetKeyState this 38)	;L[ꂽꍇ
			(def phi (+ phi 0.05))
			nil
		)

		(if (XPhBodyGetKeyState this 40)	;L[ꂽꍇ
			(def phi (+ phi -0.05))
			nil
		)

		(if (XPhBodyGetKeyState this 69)	;EL[ꂽꍇ
			((lambda ()
				(def x (- x (* (* (cos theta) (cos phi)) 0.1)))
				(def y (- y (* (* (sin theta) (cos phi)) 0.1)))
			))
			nil
		)

		(if (XPhBodyGetKeyState this 88)	;XL[ꂽꍇ
			((lambda ()
				(def x (+ x (* (* (cos theta) (cos phi)) 0.1)))
				(def y (+ y (* (* (sin theta) (cos phi)) 0.1)))
			))
			nil
		)

		'(if (XPhBodyGetKeyState this 88)	;XL[ꂽꍇ
			((lambda ()
				(def x (+ x (* (* (sin theta) (cos phi)) 0.1)))
				(def y (- y (* (* (cos theta) (cos phi)) 0.1)))
			))
			nil
		)

		(def va (list 
				(* (cos theta) (cos phi))
				(sin phi)
				(* (sin theta) (cos phi))
			)
		)

		(def va (VMul va 10))
		(def va (list (+ (select va 0) x) (select va 1) (+ (select va 2) y)))

		(SetXPhCameraMat (LookAtMat (list x 0 y) va '(0 1 0)))

		(XPhBodySetData this (list theta phi x y))

	)

)

;I^{bgǂݍ
(Load "LispCrab.lsp")


(defun CrabFunction (this)
	(let*
		(
			(data (XPhBodyGetData this))
			(jointlist (assoc_list_search data 'joints))
			(PIDList (assoc_list_search data 'PIDs))
			(t (assoc_list_search data 'ta))
			(dt (GetSimulationStepSize))
		)

		(XPhJointSetMinTheta (select (select jointlist 0) 2) 0)
		(XPhJointSetMinTheta (select (select jointlist 1) 2) 0)
		(XPhJointSetMinTheta (select (select jointlist 2) 2) 0)
		(XPhJointSetMinTheta (select (select jointlist 3) 2) 0)

		(if (< t 4.0)
			(let*
				(
					(fa 50)
				)

				(XPhJointSetBrake (select (select jointlist 0) 0) 50)
				(XPhJointSetBrake (select (select jointlist 1) 0) 50)
				(XPhJointSetBrake (select (select jointlist 2) 0) 50)
				(XPhJointSetBrake (select (select jointlist 3) 0) 50)

				(XPhJointSetStaticFrictionCoeff (select (select jointlist 0) 0) 100)
				(XPhJointSetStaticFrictionCoeff (select (select jointlist 1) 0) 100)
				(XPhJointSetStaticFrictionCoeff (select (select jointlist 2) 0) 100)
				(XPhJointSetStaticFrictionCoeff (select (select jointlist 3) 0) 100)

				(XPhJointSetDynamicFrictionCoeff (select (select jointlist 0) 0) 100)
				(XPhJointSetDynamicFrictionCoeff (select (select jointlist 1) 0) 100)
				(XPhJointSetDynamicFrictionCoeff (select (select jointlist 2) 0) 100)
				(XPhJointSetDynamicFrictionCoeff (select (select jointlist 3) 0) 100)

				(XPhJointSetTorque (select (select jointlist 0) 2) fa)
				(XPhJointSetTorque (select (select jointlist 1) 2) fa)
				(XPhJointSetTorque (select (select jointlist 2) 2) fa)
				(XPhJointSetTorque (select (select jointlist 3) 2) fa)

				(XPhJointSetTorque (select (select jointlist 0) 1) (- 0 fa))
				(XPhJointSetTorque (select (select jointlist 1) 1) (- 0 fa))
				(XPhJointSetTorque (select (select jointlist 2) 1) (- 0 fa))
				(XPhJointSetTorque (select (select jointlist 3) 1) (- 0 fa))
			)
			(let*
				(
					(fa 100)
					(fa2 200)
					(fa3 50)
					(sa 
						'(lambda (t) ()
							(if (< (sin t) 0)
								(+ 1.0 (* (sin t) 1.0))
								1.0
							)
						)
					)
					(t0 (* (sa t) (* 0.5 (PI))))
					(t1 (* (sa (+ t (PI))) (* 0.5 (PI))) )
					;(t0 (sin t))
					;(t1 (sin (+ t (PI))))
					(s0 (* (sin t) (* 0.15 (PI)) ) )
					(s1 (*  (sin (+ t (PI))) (* 0.15 (PI)) ) ) 
				)

				(XPhJointSetBrake (select (select jointlist 0) 0) 0)
				(XPhJointSetBrake (select (select jointlist 1) 0) 0)
				(XPhJointSetBrake (select (select jointlist 2) 0) 0)
				(XPhJointSetBrake (select (select jointlist 3) 0) 0)

				(XPhJointSetStaticFrictionCoeff (select (select jointlist 0) 0) 0)
				(XPhJointSetStaticFrictionCoeff (select (select jointlist 1) 0) 0)
				(XPhJointSetStaticFrictionCoeff (select (select jointlist 2) 0) 0)
				(XPhJointSetStaticFrictionCoeff (select (select jointlist 3) 0) 0)

				(XPhJointSetDynamicFrictionCoeff (select (select jointlist 0) 0) 0)
				(XPhJointSetDynamicFrictionCoeff (select (select jointlist 1) 0) 0)
				(XPhJointSetDynamicFrictionCoeff (select (select jointlist 2) 0) 0)
				(XPhJointSetDynamicFrictionCoeff (select (select jointlist 3) 0) 0)

				(JointPIDControl jointlist PIDList 0 2 fa t0 dt)
				(JointPIDControl jointlist PIDList 1 2 fa t1 dt)
				(JointPIDControl jointlist PIDList 2 2 fa t1 dt)
				(JointPIDControl jointlist PIDList 3 2 fa t0 dt)

				(XPhJointSetTorque (select (select jointlist 0) 1) (- 0 fa3))
				(XPhJointSetTorque (select (select jointlist 1) 1) (- 0 fa3))
				(XPhJointSetTorque (select (select jointlist 2) 1) (- 0 fa3))
				(XPhJointSetTorque (select (select jointlist 3) 1) (- 0 fa3))

				(JointPIDControl jointlist PIDList 0 0 fa2 s0 dt)
				(JointPIDControl jointlist PIDList 1 0 fa2 s1 dt)
				(JointPIDControl jointlist PIDList 2 0 fa2 s0 dt)
				(JointPIDControl jointlist PIDList 3 0 fa2 s1 dt)
			)
		)

		(def t (+ t 0.02))

		(if (XPhBodyGetKeyState this 83)	;sL[ꂽꍇ
			((lambda ()
				(XPhJointSetTorque (select (select jointlist 0) 2) -2)
			))
			nil
		)

		(def data (assoc_list_set data 'ta t))
		(XPhBodySetData this data)

	)
)

(def crab (MakeCrab))


(defun JointPIDControl (JointList PIDList i j fa theta dt)
	(let*
		(
			(Joint (select (select JointList i) j))
			(PID (select (select PIDList i) j))
			(dtheta (XPhJointGetDTheta Joint))
		)
		(if theta
			(XPhPIDSetTarget PID theta)
			nil
		)
		(XPhPIDSetState PID (XPhJointGetTheta Joint))
		(XPhJointSetTorque Joint (- (* (XPhPIDStep PID dt) fa) 
					(* (* dtheta fa) 0.1)))

	)
)

(defun MakePID ()
	(let*
		(
			(PID (XPhPIDMake))
		)

		(XPhPIDSetOutPutRange PID -1 1)
		(XPhPIDSetParam PID 100 0.9 0.0)
		(XPhPIDSetState PID 0.0)
		PID
	)
)

(let*
	(
		(data (XPhBodyGetData crab))
		(PIDList
			(list
				(list (MakePID) (MakePID) (MakePID))
				(list (MakePID) (MakePID) (MakePID))
				(list (MakePID) (MakePID) (MakePID))
				(list (MakePID) (MakePID) (MakePID))
			)
		)
	)

	(def data (assoc_list_set data 'ta 0.0))

	(def data (assoc_list_set data 'PIDs PIDList))

	(XPhBodySetData crab data)
)

(XPhBodySetFunction crab CrabFunction)

(SetXPhBodyMat crab '((1 0 0) (0 1 0) (0 0 1) (10 10 10))
			)


(XPhBodySetData camera_manager '(0 0 0 0))

'(XPhBodySetFunction camera_manager
		func
)

(defun makehartandcons (x num)
	(SetXPhBodyMat x (list '(1 0 0) '(0 1 0)
			'(0 0 1) (list 0 (+ 32 (* 2 num)) 0)))
	(cons x (makehearts (- num 1)))
)

(defun makehearts (num)
	(if (= num 0)
		nil
		(makehartandcons (LoadXPhBody "heart.x") num)
	)
)

(def hearts (makehearts 5))


(defun makeboxsandcons (x num)
	(SetXPhBodyMat x (list '(1 0 0) '(0 1 0)
			'(0 0 1) (list -10 (+ 32 (* 2 num)) 10)))
	(cons x (makeboxs (- num 1)))
)

(defun makeboxs (num)
	(if (= num 0)
		nil
		(makeboxsandcons (LoadXPhBody "lbox.x") num)
	)
)

(def boxs (makeboxs 5))


(XPhBodyGetFuncResult camera_manager)
(XPhBodyGetFuncResult AutoMobile)

