(load "Thruster.lsp")

(defun MakeMissle (jointmode scale)
	(let*
		(
			(missle (LoadXPhBody "missle.x"))
			(thruster nil)
			(Data nil)
		)
		(XPhBodyCollisionBoxApprox missle)
		(def thruster (MakeThruster nil nil (* scale 0.5)))
		(SetXPhBodyMat thruster 
			(list '(1 0 0) '(0 1 0) '(0 0 1) 
				(list 0 (* scale -3.25) 0))
		)

		(XPhBodyAddFixedChild missle thruster)

		(def Data (list thruster))
		(XPhBodySetData missle Data)

		missle
	)
)

