(Load "ph3dlib.lsp")

(def _camera_manager (MakeEmptyXPhBody))

(defun func (this)
	(let*
		(
			(data (XPhBodyGetData this))
			(theta (car data))
			(phi (car (cdr data)))
			(x (select data 2))
			(y (select data 3))
			(z (select data 4))
			(va '(0 0 0))
			(ova (select data 5))
		)

		(if (XPhBodyGetKeyState this 37)	;L[ꂽꍇ
			(def theta (+ theta 0.05))
			nil
		)

		(if (XPhBodyGetKeyState this 39)	;L[ꂽꍇ
			(def theta (+ theta -0.05))
			nil
		)

		(if (XPhBodyGetKeyState this 38)	;L[ꂽꍇ
			(progn
				(def phi (+ phi 0.05))
				(if (> phi (* 0.5 (PI)))
					(def phi (* 0.5 (PI)))
					nil
				)
			)
			nil
		)

		(if (XPhBodyGetKeyState this 40)	;L[ꂽꍇ
			(progn
				(def phi (+ phi -0.05))
				(if (< phi (* -0.5 (PI)))
					(def phi (* -0.5 (PI)))
					nil
				)
			)
			nil
		)

		(if (XPhBodyGetKeyState this 69)	;EL[ꂽꍇ
			((lambda ()
				(def x (- x (* (* (cos theta) (cos phi)) 0.1)))
				(def y (- y (* (* (sin theta) (cos phi)) 0.1)))
			))
			nil
		)

		(if (XPhBodyGetKeyState this 88)	;XL[ꂽꍇ
			((lambda ()
				(def x (+ x (* (* (cos theta) (cos phi)) 0.1)))
				(def y (+ y (* (* (sin theta) (cos phi)) 0.1)))
			))
			nil
		)

		(if (XPhBodyGetKeyState this VK_R)	;RL[ꂽꍇ
			((lambda ()
				(def z (+ z 0.25))
			))
			nil
		)

		(if (XPhBodyGetKeyState this VK_C)	;RL[ꂽꍇ
			((lambda ()
				(def z (- z 0.25))
			))
			nil
		)

		;'(if (XPhBodyGetKeyState this 88)	;XL[ꂽꍇ
		;	((lambda ()
		;		(def x (+ x (* (* (sin theta) (cos phi)) 0.1)))
		;		(def y (- y (* (* (cos theta) (cos phi)) 0.1)))
		;	))
		;	nil
		;)

		(def va (list 
				(* (cos theta) (cos phi))
				(sin phi)
				(* (sin theta) (cos phi))
			)
		)

		(def va (VMul va 10))
		(def va (list (+ (select va 0) x) (+ (select va 1) z) (+ (select va 2) y)))
		(def ova (VAdd (VMul va 0.1) (VMul ova 0.9)))

		(SetXPhCameraMat (LookAtMat (list x z y) ova '(0 1 0)))

		(XPhBodySetData this (list theta phi x y z ova))

		;(DrawGrid '(0 127 0 255) 10 10 '(0 0 0))
	)
)

;(XPhBodySetData _camera_manager '(0 0 0 0 0))
(XPhBodySetData _camera_manager (list (* (PI) -0.5) 0 0 0 0 '(0 0 0)))

(defun set_camera_manager_rot (theta phi)
	(let*
		(
			(obj _camera_manager)
			(data (XPhBodyGetData obj))
			(x (select data 2))
			(y (select data 3))
			(z (select data 4))
			(va '(0 0 0))
			(ova (select data 5))
		)
		(XPhBodySetData obj (list theta phi x y z ova))
	)
)

(XPhBodySetFunction _camera_manager
		func
)
(AddEditFunctionBody _camera_manager)
