;Cu̓ǂݍ
(Load "defaultlisplib.lsp")
(Load "ph3dlib.lsp")

(def Thruster_particle_manager (MakeEmptyXPhBody))
(def Thruster_particle_generator (XPhBodySetParticle Thruster_particle_manager "particle_generator"
			"kaede2.bmp" (* 256 3)))

(defun ThrusterFunction (this)
	(let*
		(
			(Mat (GetXPhBodyMat this))
			(Data (XPhBodyGetData this))
			(Force (car Data))
			(theta (car (cdr Data)))
			(jointmode (select Data 2))
			(y_axis (select Mat 1))
			(pos (select Mat 3))
			(velocity (XPhBodyGetVelocity this))
		)

		(XPhBodyAddLinearForce this
			(VMul y_axis Force)
		)

		(def pos (VSub pos (VMul y_axis 2.0)))

		(XPhMakeParticle Thruster_particle_generator 
			pos
			0.5
			(VAdd velocity (VMul y_axis (* Force -2.5)))
			(* 0.4 Force)
			'(0 -0.1 0)
			0.5 
			'(1.0 1.0 1.0 1.0)
			'(-0.2 -0.1 -0.1 -0.1)
			1.0 0.1 1.0
			5.0 1)

		(def Data (list Force theta jointmode))
		(XPhBodySetData this Data)
	)
)

(defun MakeThruster (parent jointmode)
	(let*
		(
			(box (LoadXPhBody "thrusterld.x"))
			(Data nil)
		)

		(LoadXPhBodyVisual box "thruster.x")

		(def Data (list 10 0 jointmode))

		(if parent
			(progn
				nil
			)
			(progn
				(XPhBodySetFunction box ThrusterFunction)
				(XPhBodySetData box Data)
			)
		)

		box
	)
)

(def x (MakeThruster nil nil))
(XPhBodyGetFuncResult x)

