(load "phbody.lsp")

(def pole (LoadXPhBody "touritsufuriko.x"))
(PhSetUpForFixedObject pole)
(SetXPhBodyMat pole '((1 0 0) (0 1 0) (0 0 1) (0 -2 0)))

(def tire (LoadXPhBody "tire.x"))
(SetXPhBodyMat tire '((0 1 0) (-1 0 0) (0 0 1) (1.25 1.25 0)))
(ScaleAndResetBoxInertiaTensor tire 0.25)

(print (select (GetXPhBodyGMat tire) 3) )
(print (GetXPhBodyGMat pole) )


(def jnt (XPhBodyAddJointChild pole tire
			(InvTranslate (select (GetXPhBodyGMat tire) 3) 
					(GetXPhBodyGMat pole))
				'(0 0 1) '(0 -1 0) 0.25))
(PhSetUpDefaultJointParam jnt pole tire)

(XPhJointSetTorque jnt 10.0)
(XPhJointSetTorque2 jnt 1.0)
;(XPhBodyJointLimitFlag jnt nil)

(XPhJointSetMinTheta jnt (* -0.25 (PI)))
(XPhJointSetMaxTheta jnt (* 0.25 (PI)))
(XPhJointSetMinTheta2 jnt (* -0.25 (PI)))
(XPhJointSetMaxTheta2 jnt (* 0.25 (PI)))
(XPhJointSetAxisCount jnt 2)
;(XPhBodyJointLimitFlag2 jnt nil) 


(def x pole)

(def x (XPhObjSaveLoadTest x "test.kex"))

(def floor (LoadXPhBody "road.x"))
(PhSetUpForFixedObject floor)
(SetXPhBodyMat floor '((1 0 0) (0 1 0) (0 0 1) (0 -5 0)))
(SetXPhVertexTransformMat floor '((5 0 0) (0 5 0) (0 0 5) (0 0 0)))
(XPhBodySetVisualMaterial floor '((1 1 1 1) (0.5 0.5 0.5 0.5) (0 0 0 0) 0))

