(load "phbody.lsp")
(PhDefaultParamSetUp)

;(def Thruster_particle_manager (MakeEmptyXPhBody))
;(def Thruster_particle_generator (XPhBodySetParticle Thruster_particle_manager "particle_generator"
;			"kemuri.bmp" (* 256 20)))

(defun ThrusterFunction (this)
	;(XPhSet_EasyViewText "test1")
	(let* 
		(
			(Mat (GetXPhBodyGMat this))
			(Data (XPhBodyGetData this))
			(Force (car Data))
			(theta (car (cdr Data)))
			(jointmode (select Data 2))
			(scale (select Data 3))
			(y_axis (select Mat 1))
			(pos (select Mat 3))
			(velocity (XPhBodyGetVelocity this))
			(Thruster_particle_generator (select Data 4))
		)

		(XPhBodyAddLinearForce this
			(VMul y_axis Force)
		)

		(def pos (VSub pos (VMul y_axis (* 2.0 scale))))

		;(XPhSet_EasyViewText 
		;	(PrintString Thruster_particle_generator)
		;)
		
		(XPhMakeParticle Thruster_particle_generator 
			pos
			0.2
			(VAdd velocity (VMul y_axis (* Force -1.5)))
			(* 0.2 Force)
			'(0 1.3 0)
			0.5 
			'(1.0 3.0 3.0 3.0)
			'(-1.0 -1.5 -1.5 -1.5)
			(* 1.0 scale) 0.1 1.1
			5.0 1)

		(def Data (list Force theta jointmode scale Thruster_particle_generator))
		(XPhBodySetData this Data)
	)
)

(defun MakeThruster (parent jointmode scale)
	(let*
		(
			(box (LoadXPhBody "thrusterld.x"))
			(Data nil)
		)

		(LoadXPhBodyVisual box "thruster.x")

		(def Data (list (* 30 scale) 0 jointmode scale 
					(XPhBodySetParticle box "particle_generator"
					"kemuri.bmp" 256)
				))
		(ScaleAndResetBoxInertiaTensor box scale)
		(XPhBodySetMass box scale)

		(if parent
			(progn
				nil
			)
			(progn
				(XPhBodySetFunction box ThrusterFunction)
				(XPhBodySetData box Data)
			)
		)

		box
	)
)


(def x (MakeThruster nil nil 1.0))

(def x (XPhObjSaveLoadTest x "test.kex"))

;(def Thruster_particle_manager (MakeEmptyXPhBody))
;(def Thruster_particle_generator (XPhBodySetParticle Thruster_particle_manager "particle_generator"
;			"kemuri.bmp" (* 256 20)))

(def floor (LoadXPhBody "road.x"))
(PhSetUpForFixedObject floor)
(SetXPhBodyMat floor '((1 0 0) (0 1 0) (0 0 1) (0 -5 0)))
(SetXPhVertexTransformMat floor '((5 0 0) (0 5 0) (0 0 5) (0 0 0)))
(XPhBodySetVisualMaterial floor '((1 1 1 1) (0.5 0.5 0.5 0.5) (0 0 0 0) 0))

(XPhBodyGetFuncResult x)
(XPhBodyGetFunction x)
(XPhBodyGetData x)


