;Cu̓ǂݍ
(Load "defaultlisplib.lsp")
(Load "ph3dlib.lsp")

(def Thruster_particle_manager (MakeEmptyXPhBody))
(def Thruster_particle_generator (XPhBodySetParticle Thruster_particle_manager "particle_generator"
			"blue.bmp" (* 256 20)))

(defun ThrusterFunction (this)
	;(XPhSet_EasyViewText "test1")
	(let*
		(
			(Mat (GetXPhBodyGMat this))
			(Data (XPhBodyGetData this))
			(Force (car Data))
			(theta (car (cdr Data)))
			(jointmode (select Data 2))
			(scale (select Data 3))
			(y_axis (select Mat 1))
			(pos (select Mat 3))
			(velocity (XPhBodyGetVelocity this))
		)

		(XPhBodyAddLinearForce this
			(VMul y_axis Force)
		)

		(def pos (VSub pos (VMul y_axis (* 2.0 scale))))

		(XPhMakeParticle Thruster_particle_generator 
			pos
			0.2
			(VAdd velocity (VMul y_axis (* Force -2.5)))
			(* 0.8 Force)
			'(0 -0.1 0)
			0.5 
			'(1.0 1.0 1.0 1.0)
			'(-0.2 -0.1 -0.1 -0.1)
			(* 1.15 scale) 0.1 0.5
			5.0 1)

		(def Data (list Force theta jointmode scale))
		(XPhBodySetData this Data)
	)
)

(defun MakeThruster (parent jointmode scale)
	(let*
		(
			(box (LoadXPhBody "thrusterld.x"))
			(Data nil)
		)

		(LoadXPhBodyVisual box "thruster.x")

		(def Data (list (* 30 scale) 0 jointmode scale))
		(ScaleAndResetBoxInertiaTensor box scale)
		(XPhBodySetMass box scale)

		(if parent
			(progn
				nil
			)
			(progn
				(XPhBodySetFunction box ThrusterFunction)
				(XPhBodySetData box Data)
			)
		)

		box
	)
)


