;Cu̓ǂݍ
(load "phbody.lsp")

(defun TwoLegClass_MakeBody ()
	(let*
		(
			(local_body (LoadXPhBody "dleg.x"))
		)

		(XPhBodySetMass local_body 4.0)
		(ScaleAndResetBoxInertiaTensor local_body 1.0)

		;right leg

		(def rlg0 (LoadXPhBody "robolx/rlg0.x"))
		(XPhBodyVertexTransFormToCenter rlg0)
		(if BoxApprox
			(XPhBodyCollisionBoxApprox rlg0)
			nil
		)
		(XPhBodySetVisualMaterial rlg0 '((0.25 0.25 0.25 1) (0.1 0.1 0.1 0.1) (0 0 0 0) 0))
		(XPhBodySetMass rlg0 0.5)
		(SetXPhBodyMat rlg0 '((1 0 0) (0 1 0) (0 0 1) (0 0 0)))
		(ScaleAndResetBoxInertiaTensor rlg0 1.0)

		(def rlg1 (LoadXPhBody "robolx/rlg1.x"))
		(XPhBodyVertexTransFormToCenter rlg1)
		(if BoxApprox
			(XPhBodyCollisionBoxApprox rlg1)
			nil
		)
		(XPhBodySetVisualMaterial rlg1 '((0.9 0.25 0.25 1) (0.5 0.1 0.1 0.1) (0 0 0 0) 0))
		(XPhBodySetMass rlg1 1.0)
		(SetXPhBodyMat rlg1 '((1 0 0) (0 1 0) (0 0 1) (-0.01 -0.6 0.15)))
		(ScaleAndResetBoxInertiaTensor rlg1 1.0)

		(def rlg2 (LoadXPhBody "robolx/rlg2.x"))
		(XPhBodyVertexTransFormToCenter rlg2)
		(if BoxApprox
			(XPhBodyCollisionBoxApprox rlg2)
			nil
		)
		(XPhBodySetVisualMaterial rlg2 '((0.25 0.25 0.25 1) (0.1 0.1 0.1 0.1) (0 0 0 0) 0))
		(XPhBodySetMass rlg2 0.5)
		(SetXPhBodyMat rlg2 '((1 0 0) (0 1 0) (0 0 1) (0 -1.2 0.05)))
		(ScaleAndResetBoxInertiaTensor rlg2 1.0)

		(def rlg3 (LoadXPhBody "robolx/rlg3.x"))
		(XPhBodyVertexTransFormToCenter rlg3)
		(if BoxApprox
			(XPhBodyCollisionBoxApprox rlg3)
			nil
		)
		(XPhBodySetVisualMaterial rlg3 '((0.9 0.25 0.25 1) (0.5 0.1 0.1 0.1) (0 0 0 0) 0))
		(XPhBodySetMass rlg3 1.5)
		(SetXPhBodyMat rlg3 '((1 0 0) (0 1 0) (0 0 1) (-0.01 -2.0 0.35)))
		(ScaleAndResetBoxInertiaTensor rlg3 1.0)

		(def rlg4 (LoadXPhBody "robolx/rlg4.x"))
		(XPhBodyVertexTransFormToCenter rlg4)
		(if BoxApprox
			(XPhBodyCollisionBoxApprox rlg4)
			nil
		)
		(XPhBodySetVisualMaterial rlg4 '((0.25 0.25 0.25 1) (0.1 0.1 0.1 0.1) (0 0 0 0) 0))
		(XPhBodySetMass rlg4 0.5)
		(SetXPhBodyMat rlg4 '((1 0 0) (0 1 0) (0 0 1) (0 -2.8 0.2)))
		(ScaleAndResetBoxInertiaTensor rlg4 1.0)

		(def rlg5 (LoadXPhBody "robolx/rlg5.x"))
		(XPhBodyVertexTransFormToCenter rlg5)
		(if BoxApprox
			(XPhBodyCollisionBoxApprox rlg5)
			nil
		)
		(XPhBodySetVisualMaterial rlg5 '((0.9 0.25 0.25 1) (0.5 0.1 0.1 0.1) (0 0 0 0) 0))
		(XPhBodySetMass rlg5 1.0)
		(SetXPhBodyMat rlg5 '((1 0 0) (0 1 0) (0 0 1) (-0.01 -3.1 0.45)))
		(ScaleAndResetBoxInertiaTensor rlg5 1.0)

		(XPhBodyAddFixedChild rlg1 rlg0)
		(XPhBodyAddFixedChild rlg3 rlg2)
		(XPhBodyAddFixedChild rlg5 rlg4)

		
		(print (InvTranslate (select (GetXPhBodyGMat rlg0) 3) 
							(GetXPhBodyGMat rlg1)))
		(def rjnt1 (XPhBodyAddJointChild rlg1 rlg3
					(InvTranslate (select (GetXPhBodyGMat rlg2) 3) 
							(GetXPhBodyGMat rlg1))
						'(1 0 0) '(0 0 -1) 0.25))
		(PhSetUpDefaultJointParam rjnt1 rlg1 rlg3)

		(XPhJointSetMaxTheta rjnt1 (* 0.5 (PI)))
		(XPhJointSetMinTheta rjnt1 (* 0.0 (PI)))

		(def rjnt2 (XPhBodyAddJointChild rlg3 rlg5
					(InvTranslate (select (GetXPhBodyGMat rlg4) 3) 
							(GetXPhBodyGMat rlg3))
						'(1 0 0) '(0 0 -1) 0.25))
		(PhSetUpDefaultJointParam rjnt2 rlg3 rlg5)

		(XPhJointSetMaxTheta rjnt2 (* 0.15 (PI)))
		(XPhJointSetMinTheta rjnt2 (* -0.15 (PI)))

		(XPhBodySetEachChildNoCollision rlg1)
		;(def local_body rlg1)
		;(def rlg1 nil)

		(SetXPhBodyMat rlg1 '((1 0 0)(0 1 0)(0 0 1)(1 -1 0)))

		(def rjnt0 (XPhBodyAddJointChild local_body rlg1
					(InvTranslate (select (GetXPhBodyGMat rlg0) 3) 
							(GetXPhBodyGMat local_body))
						'(1 0 0) '(0 0 -1) 0.25))
		(PhSetUpDefaultJointParam rjnt0 local_body rlg1)

		(XPhJointSetMaxTheta rjnt0 (* 0.15 (PI)))
		(XPhJointSetMinTheta rjnt0 (* -0.5 (PI)))

		;left leg

		(def llg0 (LoadXPhBody "robolx/llg0.x"))
		(XPhBodyVertexTransFormToCenter llg0)
		(if BoxApprox
			(XPhBodyCollisionBoxApprox llg0)
			nil
		)
		(XPhBodySetVisualMaterial llg0 '((0.25 0.25 0.25 1) (0.1 0.1 0.1 0.1) (0 0 0 0) 0))
		(XPhBodySetMass llg0 0.5)
		(SetXPhBodyMat llg0 '((1 0 0) (0 1 0) (0 0 1) (0 0 0)))
		(ScaleAndResetBoxInertiaTensor llg0 1.0)

		(def llg1 (LoadXPhBody "robolx/llg1.x"))
		(XPhBodyVertexTransFormToCenter llg1)
		(if BoxApprox
			(XPhBodyCollisionBoxApprox llg1)
			nil
		)
		(XPhBodySetVisualMaterial llg1 '((0.9 0.25 0.25 1) (0.5 0.1 0.1 0.1) (0 0 0 0) 0))
		(XPhBodySetMass llg1 1.0)
		(SetXPhBodyMat llg1 '((1 0 0) (0 1 0) (0 0 1) (-0.01 -0.6 0.15)))
		(ScaleAndResetBoxInertiaTensor llg1 1.0)

		(def llg2 (LoadXPhBody "robolx/llg2.x"))
		(XPhBodyVertexTransFormToCenter llg2)
		(if BoxApprox
			(XPhBodyCollisionBoxApprox llg2)
			nil
		)
		(XPhBodySetVisualMaterial llg2 '((0.25 0.25 0.25 1) (0.1 0.1 0.1 0.1) (0 0 0 0) 0))
		(XPhBodySetMass llg2 0.5)
		(SetXPhBodyMat llg2 '((1 0 0) (0 1 0) (0 0 1) (0 -1.2 0.05)))
		(ScaleAndResetBoxInertiaTensor llg2 1.0)

		(def llg3 (LoadXPhBody "robolx/llg3.x"))
		(XPhBodyVertexTransFormToCenter llg3)
		(if BoxApprox
			(XPhBodyCollisionBoxApprox llg3)
			nil
		)
		(XPhBodySetVisualMaterial llg3 '((0.9 0.25 0.25 1) (0.5 0.1 0.1 0.1) (0 0 0 0) 0))
		(XPhBodySetMass llg3 1.5)
		(SetXPhBodyMat llg3 '((1 0 0) (0 1 0) (0 0 1) (-0.01 -2.0 0.35)))
		(ScaleAndResetBoxInertiaTensor llg3 1.0)

		(def llg4 (LoadXPhBody "robolx/llg4.x"))
		(XPhBodyVertexTransFormToCenter llg4)
		(if BoxApprox
			(XPhBodyCollisionBoxApprox llg4)
			nil
		)
		(XPhBodySetVisualMaterial llg4 '((0.25 0.25 0.25 1) (0.1 0.1 0.1 0.1) (0 0 0 0) 0))
		(XPhBodySetMass llg4 0.5)
		(SetXPhBodyMat llg4 '((1 0 0) (0 1 0) (0 0 1) (0 -2.8 0.2)))
		(ScaleAndResetBoxInertiaTensor llg4 1.0)

		(def llg5 (LoadXPhBody "robolx/llg5.x"))
		(XPhBodyVertexTransFormToCenter llg5)
		(if BoxApprox
			(XPhBodyCollisionBoxApprox llg5)
			nil
		)
		(XPhBodySetVisualMaterial llg5 '((0.9 0.25 0.25 1) (0.5 0.1 0.1 0.1) (0 0 0 0) 0))
		(XPhBodySetMass llg5 1.0)
		(SetXPhBodyMat llg5 '((1 0 0) (0 1 0) (0 0 1) (-0.01 -3.1 0.45)))
		(ScaleAndResetBoxInertiaTensor llg5 1.0)

		(XPhBodyAddFixedChild llg1 llg0)
		(XPhBodyAddFixedChild llg3 llg2)
		(XPhBodyAddFixedChild llg5 llg4)

		
		(print (InvTranslate (select (GetXPhBodyGMat llg0) 3) 
							(GetXPhBodyGMat llg1)))
		(def ljnt1 (XPhBodyAddJointChild llg1 llg3
					(InvTranslate (select (GetXPhBodyGMat llg2) 3) 
							(GetXPhBodyGMat llg1))
						'(1 0 0) '(0 0 -1) 0.25))
		(PhSetUpDefaultJointParam ljnt1 llg1 llg3)

		(XPhJointSetMaxTheta ljnt1 (* 0.5 (PI)))
		(XPhJointSetMinTheta ljnt1 (* 0.0 (PI)))

		(def ljnt2 (XPhBodyAddJointChild llg3 llg5
					(InvTranslate (select (GetXPhBodyGMat llg4) 3) 
							(GetXPhBodyGMat llg3))
						'(1 0 0) '(0 0 -1) 0.25))
		(PhSetUpDefaultJointParam ljnt2 llg3 llg5)

		(XPhJointSetMaxTheta ljnt2 (* 0.15 (PI)))
		(XPhJointSetMinTheta ljnt2 (* -0.15 (PI)))

		(XPhBodySetEachChildNoCollision llg1)
		;(def local_body llg1)
		;(def llg1 nil)

		(SetXPhBodyMat llg1 '((1 0 0)(0 1 0)(0 0 1)(-1 -1 0)))

		(def ljnt0 (XPhBodyAddJointChild local_body llg1
					(InvTranslate (select (GetXPhBodyGMat llg0) 3) 
							(GetXPhBodyGMat local_body))
						'(1 0 0) '(0 0 -1) 0.25))
		(PhSetUpDefaultJointParam ljnt0 local_body llg1)

		(XPhJointSetMaxTheta ljnt0 (* 0.15 (PI)))
		(XPhJointSetMinTheta ljnt0 (* -0.5 (PI)))

		local_body
	)
)

(def TwoLegClass
	(PhClass_Inherit PhBodyClass
		'(
			(DebugMode t)
			(States 
				(WalkTurn 0.0 0.0)
			)
			(BoxApprox nil)
			(MakeBody
				'(lambda (v w)
					(TwoLegClass_MakeBody)
				)
			)

			(rlg0 nil) (rlg1 nil) (rlg2 nil)
			(rlg3 nil) (rlg4 nil) (rlg5 nil)

			(rjnt0 nil) (rjnt1 nil) (rjnt2 nil)

			(llg0 nil) (llg1 nil) (llg2 nil)
			(llg3 nil) (llg4 nil) (llg5 nil)

			(ljnt0 nil) (ljnt1 nil) (ljnt2 nil)

			(joints nil)
			(tirelist nil)
			(WalkTurn
				'(lambda (v w)
					nil
				)
			)

			(Init
				'(lambda ()
					(inherited)
					
				)
			)
		)
	)
)





