(load "LispCart.lsp")

'(XPhSet_EasyViewText 
	(strcat
		"J[\L[ŕs\n"
		"E,Xŏ㏸~\n"
		"Sł\n"
		"Z,CōEɐ\n"
		"Bň胂[h\n"
		"Vň胂[h\n"
		"I,M,J,KőO㍶EɈړ\n"
	)
)

(load "RotationalCamera.lsp")
(load "MousePicker.lsp")

;΂ˌWȂǂ̃p[^̏
(PhDefaultParamSetUp)
;(SetCollisionSpringCoeff 20.0)
;(SetCollisionSpringCoeff 15.0)

(XPhBgColor 230 230 233)

;߂荞݋eʂ̐ݒ
(SetInterferencePermitDistance 0.05)

;Î~CW̐ݒ
(SetCollisionStaticFrictionCoeff 0.8)

;CW̐ݒ
(SetCollisionDynamicFrictionCoeff 0.7)

;̌`t@C̓ǂݍ
(def floor (LoadXPhBody "road.x"))
;(def floor (LoadXPhBody "pala.x"))
(PhSetUpForFixedObject floor)
(SetXPhBodyMat floor '((1 0 0) (0 1 0) (0 0 1) (0 -5 0)))
(SetXPhVertexTransformMat floor '((5 0 0) (0 5 0) (0 0 5) (0 0 0)))
(XPhBodySetVisualMaterial floor '((1 1 1 1) (0.5 0.5 0.5 0.5) (0 0 0 0) 0))

(def pendulum (LoadXPhBody "touritsufuriko.x"))
(SetXPhBodyMat pendulum '((1 0 0) (0 1 0) (0 0 1) (0 2.5 0)))
(ScaleAndResetBoxInertiaTensor pendulum 1.5)


(def cart (MakeCart
		'(
			(DebugMode t)
			(KeyRun
				'(lambda ()
					(if (XPhBodyGetKeyState this VK_UP)
						(WalkTurn 1.0 0.0)
					(if (XPhBodyGetKeyState this VK_DOWN)
						(WalkTurn -1.0 0.0)
						(WalkTurn 0.0 0.0)
					))
					
				)
			)

			(old_ya_z 0.0)
			(old_pa_z 0.0)

			(IPendulumStand
				'(lambda ()
					(let*
						(
							(pdMat (GetXPhBodyMat pendulum))
							(ya (select pdMat 1))
							(ya_z (select ya 2))
							(Mat (GetXPhBodyMat this))
							(pa (select Mat 3))
							(pa_z (select pa 2))
							(axel 0.0)
						)

						(if DebugMode (AddDebugString (strcat "ya_z = " (PrintString ya_z) "\n")) nil)
						(if DebugMode (AddDebugString (strcat "pa_z = " (PrintString pa_z) "\n")) nil)
						
						(if (> pa_z 1.0)
							(def pa_z 1.0)
							nil
						)
						(if (< pa_z -1.0)
							(def pa_z -1.0)
							nil
						)

						(def ya_z (asin ya_z))

						(def axel
							(+
								(+ (* ya_z 130) (* pa_z 1)) 
								(+ (* (- ya_z old_ya_z) 80) (* (- pa_z old_pa_z) 1)) 
							)
						)

						(if (> axel 5.0)
							(def axel 5.0)
							nil
						)

						(if (< axel -5.0)
							(def axel -5.0)
							nil
						)

						(WalkTurn 
									axel
								0.0)

						(def old_ya_z ya_z)
						(def old_pa_z pa_z)
					)
				)
			)

			(States
				;(KeyRun)
				(IPendulumStand)
			)
		)

	)
)

(SetXPhBodyMat cart '((1 0 0) (0 1 0) (0 0 1) (0 -3 0)))

;(XPhBodyGetFuncResult cart)
