(load "LispCart.lsp")

'(XPhSet_EasyViewText 
	(strcat
		"J[\L[ŕs\n"
		"E,Xŏ㏸~\n"
		"Sł\n"
		"Z,CōEɐ\n"
		"Bň胂[h\n"
		"Vň胂[h\n"
		"I,M,J,KőO㍶EɈړ\n"
	)
)

(load "RotationalCamera.lsp")
(load "MousePicker.lsp")

;΂ˌWȂǂ̃p[^̏
(PhDefaultParamSetUp)
;(SetCollisionSpringCoeff 20.0)
(SetCollisionSpringCoeff 15.0)
(SetGravity (* 9.8 10))

(XPhBgColor 200 200 203)

;߂荞݋eʂ̐ݒ
(SetInterferencePermitDistance 0.05)

;Î~CW̐ݒ
(SetCollisionStaticFrictionCoeff 0.8)

;CW̐ݒ
(SetCollisionDynamicFrictionCoeff 0.7)

;̌`t@C̓ǂݍ
(def floor (LoadXPhBody "road.x"))
;(def floor (LoadXPhBody "pala.x"))
(PhSetUpForFixedObject floor)
(SetXPhBodyMat floor '((1 0 0) (0 1 0) (0 0 1) (0 -5 0)))
(SetXPhVertexTransformMat floor '((5 0 0) (0 5 0) (0 0 5) (0 0 0)))
(XPhBodySetVisualMaterial floor '((1 1 1 1) (0.5 0.5 0.5 0.5) (0 0 0 0) 0))

(def pendulum (LoadXPhBody "touritsufuriko.x"))
(SetXPhBodyMat pendulum '((1 0 0) (0 1 0) (0 0 1) (0 3.5 0)))
(ScaleAndResetBoxInertiaTensor pendulum 1.5)


(def cartClassMember
		'(
			(DebugMode t)
			(KeyRun
				'(lambda ()
					(if (XPhBodyGetKeyState this VK_UP)
						(WalkTurn 1.0 0.0)
					(if (XPhBodyGetKeyState this VK_DOWN)
						(WalkTurn -1.0 0.0)
						(WalkTurn 0.0 0.0)
					))
					
				)
			)

			(old_ya_z 0.0)
			(old_pa_z 0.0)

			(time_counter 0.0)

			;(k0 312)
			;(k1 357)
			;(k2 2.2)
			;(k3 1.1)

			(k0 970)
			(k1 1500)
			(k2 5.33)
			(k3 18.0)

			(IPendulumStand
				'(lambda ()
					(let*
						(
							(Mat (GetXPhBodyMat this))
							(za (select Mat 2))
							(pa (select Mat 3))
							(pa_z (select pa 2))
							(axel 0.0)
							(pdMat (GetXPhBodyMat pendulum))
							(ya (select pdMat 1))
							(ya_z (VDot za ya))
							
							
						)

						(if DebugMode (AddDebugString (strcat "ya_z = " (PrintString ya_z) "\n")) nil)
						(if DebugMode (AddDebugString (strcat "pa_z = " (PrintString pa_z) "\n")) nil)
						
						(if (> pa_z 1.0)
							(def pa_z 1.0)
							nil
						)
						(if (< pa_z -1.0)
							(def pa_z -1.0)
							nil
						)

						(def ya_z (asin ya_z))

						(def axel
							(* (+
								(+ (* ya_z k0) (* pa_z k2)) 
								(+ (* (- ya_z old_ya_z) k1) (* (- pa_z old_pa_z) k3)) 
							) 2.0)
						)

						(if (> axel 50.0)
							(def axel 50.0)
							nil
						)

						(if (< axel -50.0)
							(def axel -50.0)
							nil
						)

						(WalkTurn 
									axel
								0.0)

						(def old_ya_z ya_z)
						(def old_pa_z pa_z)

						(if (or (> ya_z (* (PI) 0.25)) (< ya_z (* (PI) -0.25)))
							(progn
								(SetXPhBodyMat pendulum '((1 0 0) (0 1 0) (0 0 1) (0 3.5 0)))
								(SetXPhBodyMat this '((1 0 0) (0 1 0) (0 0 1) (0 -3 0)))
								
								(XPhBodySetVelocity pendulum '(0 0 0))
								(XPhBodySetAVelocity pendulum '(0 0 0))
								(XPhBodySetVelocity this '(0 0 0))
								(XPhBodySetAVelocity this '(0 0 0))
								(WalkTurn 0.0 0.0)
								
								(XPhBodySetVelocity (select tirelist 0) '(0 0 0))
								(XPhBodySetAVelocity (select tirelist 0) '(0 0 0))
								(XPhBodySetVelocity (select tirelist 1) '(0 0 0))
								(XPhBodySetAVelocity (select tirelist 1) '(0 0 0))
								(XPhBodySetVelocity (select tirelist 2) '(0 0 0))
								(XPhBodySetAVelocity (select tirelist 2) '(0 0 0))
								(XPhBodySetVelocity (select tirelist 3) '(0 0 0))
								(XPhBodySetAVelocity (select tirelist 3) '(0 0 0))

								(def k0 970)
								(def k1 1500)
								(def k2 5.33)
								(def k3 18.000000)

								(def k0 (* k0 (+ (/ (mod (rand) 600) 300.0) 0.5)))
								(def k1 (* k1 (+ (/ (mod (rand) 600) 300.0) 0.5)))
								(def k2 (* k2 (+ (/ (mod (rand) 600) 300.0) 0.5)))
								(def k3 (* k3 (+ (/ (mod (rand) 600) 300.0) 0.5)))

								(def time_counter 0.0)
								
								(if DebugMode (AddDebugString "renew\n") nil)
							)
							nil
						)

						(if DebugMode (AddDebugString (strcat "k0 = " (PrintString k0) "\n")) nil)
						(if DebugMode (AddDebugString (strcat "k1 = " (PrintString k1) "\n")) nil)
						(if DebugMode (AddDebugString (strcat "k2 = " (PrintString k2) "\n")) nil)
						(if DebugMode (AddDebugString (strcat "k3 = " (PrintString k3) "\n")) nil)

						(if DebugMode (AddDebugString (strcat "time_counter = " (PrintString time_counter) "\n")) nil)
						(if (> time_counter 1040.0)
							(progn
								(SaveAtom (strcat "sdata" (PrintString k0) ".txt")
									(list k0 k1 k2 k3))
								(def time_counter 0.0)
							)
							nil
						)

						(def time_counter (+ time_counter dt))
						
					)
				)
			)

			(States
				;(KeyRun)
				(IPendulumStand)
			)
		)
)

(def cart (MakeCart
			cartClassMember
))

(SetXPhBodyMat cart '((1 0 0) (0 1 0) (0 0 1) (0 -3 0)))

;(XPhBodyGetFuncResult cart)
