;Cu̓ǂݍ
(Load "defaultlisplib.lsp")
(Load "ph3dlib.lsp")
(load "LispAutoMobile.lsp")
(load "phbody.lsp")

(defun MakeCartTire (body dir up st offset)
	(let*
		(
			(data (XPhBodyGetData body))
			(jointlist (assoc_list_search data 'joints))
			(tire (LoadXPhBody "tireld.x"))
			(scale 0.2)

			(mat (GetXPhBodyMat body))
			(cp (VCross dir up))
			(ma nil)
			(sta (VAdd st (select mat 3)))
		)

		(LoadXPhBodyVisual tire "tire.x")
		(XPhBodySetMass tire 1.0)
		(XPhBodySetVisualMaterial tire '((1 1 1 1) (0.5 0.5 0.5 0.5) (0 0 0 0) 0))
		(ScaleAndResetBoxInertiaTensor tire scale)
		
		(SetXPhVertexTransformMat tire 
			(AppendMatVec 
				(YRotMat (* -0.5 (PI)))
				'(0 0 0)
			)
			
		)

		(def ma (LookAtMat (VAdd sta cp) sta up))

		(SetXPhBodyMat tire ma)

		(let*
			(
				(jnt (XPhBodyAddJointChild body tire
					 (VAdd st offset)
						dir up (* 1.25 scale)))
			)

			(PhSetUpDefaultJointParam jnt body tire)
			(XPhJointSetRotationalDamper jnt 0.2)
			;(XPhBodyJointSpringCoeff jnt 0.1)
			'(XPhBodyJointSpringDamper jnt 4.5)

			(XPhBodyJointLimitFlag jnt nil)


			(def data (assoc_list_set data 'joints 
				(cons jnt jointlist))
			)

			(XPhBodySetData body data)
		)

		tire
	)
)

(def CartClass
	(PhClass_Inherit PhBodyClass
		'(
			(DebugMode t)
			(States 
				(WalkTurn 0.0 0.0)
			)
			(joints nil)
			(tirelist nil)
			(WalkTurn
				'(lambda (v w)
					(XPhJointSetTorque (select joints 0) (+ v w))
					(XPhJointSetTorque (select joints 1) (+ v w))
					(XPhJointSetTorque (select joints 2) (- v w))
					(XPhJointSetTorque (select joints 3) (- v w))
					(AddDebugString "WalkTurn\n")
				)
			)

			(Init
				'(lambda ()
					(inherited)
					
				)
			)
		)
	)
)

(defun MakeCart (ncls)
	(let*
		(
			(AutoMobile (LoadXPhBody "chassis.x"))
			(ist nil)
			(tmptirelist nil)
		)

		;(LoadXPhBodyVisual AutoMobile "kbody.x")
		(SetXPhBodyMat AutoMobile '((1 0 0) (0 1 0) (0 0 1) (0 5 0)))
		(SetXPhVertexTransformMat AutoMobile 
			;'((0.25 0 0) (0 0.25 0) (0 0 0.25) (0 5 0))
			(AppendMatVec 
				(MatMul
					(YRotMat (* 0.5 (PI)))
					(ScaleMat 0.3)
				)
				'(0 0.0 -0.8)
			)
		)

		(XPhBodySetMass AutoMobile 4.0)
		(ScaleAndResetBoxInertiaTensor AutoMobile 1.0)

		(XPhBodySetData AutoMobile nil)

		(def tmptirelist
			(list
				(MakeCartTire AutoMobile '(1 0 0) '(0 1 0)
						'(1.25 -0.45 1.5) '(-0.25 0 0))
				(MakeCartTire AutoMobile '(1 0 0) '(0 1 0)
						'(1.25 -0.45 -1.5) '(-0.25 0 0))
				(MakeCartTire AutoMobile '(1 0 0) '(0 1 0)
						'(-1.25 -0.45 1.5) '(0.25 0 0))
				(MakeCartTire AutoMobile '(1 0 0) '(0 1 0)
						'(-1.25 -0.45 -1.5) '(0.25 0 0))
			)
		)

		(def ncls (PhClass_Inherit CartClass ncls))

		(def ist (PhClass_Create ncls))
		(with ist
			(def joints (assoc_list_search (XPhBodyGetData AutoMobile) 'joints))
			(def tirelist tmptirelist)
		)
		(PhClass_SetFunction AutoMobile ist)
		AutoMobile
	)
)
(print "MakeCart")
MakeCart


